/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.iterator.IteratorWrapper;

public class IteratorOnClose<T>
extends IteratorWrapper<T>
implements IteratorCloseable<T> {
    private final Runnable closeHandler;
    private boolean hasClosed = false;

    public static <T> IteratorOnClose<T> atEnd(Iterator<T> iterator, Runnable closeHandler) {
        return new IteratorOnClose<T>(iterator, closeHandler);
    }

    private IteratorOnClose(Iterator<T> iterator, Runnable closeHandler) {
        super(iterator);
        this.closeHandler = closeHandler;
    }

    @Override
    public boolean hasNext() {
        if (this.hasClosed) {
            return false;
        }
        boolean b = super.hasNext();
        if (!b) {
            this.close();
        }
        return b;
    }

    @Override
    public T next() {
        try {
            return this.get().next();
        }
        catch (NoSuchElementException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        super.forEachRemaining(action);
        this.close();
    }

    @Override
    public void close() {
        if (!this.hasClosed) {
            try {
                if (this.closeHandler != null) {
                    this.closeHandler.run();
                }
            }
            finally {
                this.hasClosed = true;
            }
        }
        super.close();
    }
}

