/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ModDataset;
import java.util.List;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.util.DatasetUtils;
import org.apache.jena.system.Txn;

public class ModDatasetGeneral
extends ModDataset {
    protected final ArgDecl graphDecl = new ArgDecl(true, "graph");
    protected final ArgDecl dataDecl = new ArgDecl(true, "data");
    protected final ArgDecl namedGraphDecl = new ArgDecl(true, "named", "namedgraph", "namedGraph", "namedData", "nameddata");
    private List<String> dataURLs = null;
    private List<String> graphURLs = null;
    private List<String> namedGraphURLs = null;

    protected ModDatasetGeneral() {
    }

    @Override
    public void registerWith(CmdGeneral cl) {
        cl.getUsage().startCategory("Dataset");
        cl.add(this.dataDecl, "--data=FILE", "Data for the dataset - triple or quad formats.  --data can be used for multiple times in the same command. FILE can be a URL (http/https)");
        cl.add(this.graphDecl, "--graph=FILE", "Graph for default graph of the dataset. FILE can be a URL (http/https)");
        cl.add(this.namedGraphDecl, "--namedGraph=FILE", "Add a graph into the dataset as a named graph.  --namedGraph can be used multiple times in the same command.  FILE in this case can only be a file, not a URL.  It will be called <FILE> even if a local path of /data/sub1/FILE");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.dataURLs = cmdLine.getValues(this.dataDecl);
        this.graphURLs = cmdLine.getValues(this.graphDecl);
        this.namedGraphURLs = cmdLine.getValues(this.namedGraphDecl);
    }

    @Override
    public Dataset createDataset() {
        if (!(this.dataURLs != null && this.dataURLs.size() != 0 || this.graphURLs != null && this.graphURLs.size() != 0 || this.namedGraphURLs != null && this.namedGraphURLs.size() != 0)) {
            return null;
        }
        Dataset ds = DatasetFactory.createTxnMem();
        this.addGraphs(ds);
        this.dataset = ds;
        return this.dataset;
    }

    static <X> boolean hasEntries(List<X> list) {
        if (list == null) {
            return false;
        }
        return !list.isEmpty();
    }

    protected void addGraphs(Dataset ds) {
        try {
            if (ModDatasetGeneral.hasEntries(this.dataURLs)) {
                if (ds.supportsTransactions()) {
                    Txn.executeWrite(ds, () -> {
                        for (String url : this.dataURLs) {
                            RDFDataMgr.read(ds, url);
                        }
                    });
                } else {
                    for (String url : this.dataURLs) {
                        RDFDataMgr.read(ds, url);
                    }
                }
            }
            if (ModDatasetGeneral.hasEntries(this.graphURLs) || ModDatasetGeneral.hasEntries(this.namedGraphURLs)) {
                List<String> x = this.namedGraphURLs.stream().map(IRILib::filenameToIRI).toList();
                DatasetUtils.addInGraphs(ds, this.graphURLs, x, null);
            }
        }
        catch (JenaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Error creating dataset", ex);
        }
    }

    public List<String> getGraphURLs() {
        return this.graphURLs;
    }

    public List<String> getNamedGraphURLs() {
        return this.namedGraphURLs;
    }
}

