/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class OntConfig {
    public static final OntConfig DEFAULT = new OntConfig();
    private final Map<String, Object> settings;

    public OntConfig() {
        this(Map.of());
    }

    protected OntConfig(Map<String, Object> settings) {
        this.settings = Map.copyOf(Objects.requireNonNull(settings));
    }

    public boolean getBoolean(Enum<?> key) {
        return this.getBoolean(key.name());
    }

    public boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Config contains value for key = " + key + ", but it is not a boolean");
    }

    public Object get(String key) {
        return this.settings.get(key);
    }

    public OntConfig setTrue(Enum<?> key) {
        return this.setBoolean(key, true);
    }

    public OntConfig setFalse(Enum<?> key) {
        return this.setBoolean(key, false);
    }

    public OntConfig setBoolean(Enum<?> key, boolean value) {
        return this.setBoolean(key.name(), value);
    }

    public OntConfig setBoolean(String key, boolean value) {
        return this.set(key, value);
    }

    public OntConfig set(String key, Object value) {
        HashMap<String, Object> settings = new HashMap<String, Object>(this.settings);
        settings.put(key, value);
        return new OntConfig(settings);
    }
}

