/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Union;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.DyadicDatasetGraph;

public class UnionDatasetGraph
extends DyadicDatasetGraph {
    public UnionDatasetGraph(DatasetGraph left, DatasetGraph right, Context c) {
        super(left, right, c);
    }

    private Graph union(Function<DatasetGraph, Graph> op) {
        return (Graph)this.apply(UnionView::new, op);
    }

    <T> Iter<T> fromEach(Function<DatasetGraph, Iterator<T>> op) {
        return ((Iter)this.apply(Iter::concat, op)).distinct();
    }

    @Override
    public Graph getDefaultGraph() {
        return this.union(DatasetGraph::getDefaultGraph);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return this.union(dsg -> dsg.getGraph(graphNode));
    }

    @Override
    public Graph getUnionGraph() {
        return this.union(DatasetGraph::getUnionGraph);
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.either(dsg -> dsg.containsGraph(graphNode));
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.fromEach(DatasetGraph::listGraphNodes);
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        return this.fromEach(dsg -> dsg.find(g, s, p, o));
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        return this.fromEach(dsg -> dsg.findNG(g, s, p, o));
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        return this.either(dsg -> dsg.contains(g, s, p, o));
    }

    @Override
    public boolean isEmpty() {
        return this.both(DatasetGraph::isEmpty);
    }

    static class UnionView
    extends Union {
        public UnionView(Graph L, Graph R) {
            super(L, R);
        }

        public void performAdd(Triple t) {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        public void performDelete(Triple t) {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        public void remove(Node s, Node p, Node o) {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }

        public void clear() {
            DyadicDatasetGraph.throwNoMutationAllowed();
        }
    }
}

