/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import jakarta.inject.Inject;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.core.ConnectionDescription;

public interface ConnectionDescriptionSupplier {
    public Stream<ConnectionDescription> describeConnections();

    public static class CompositeConnectionDescriptionSupplier
    implements ConnectionDescriptionSupplier {
        private final Set<ConnectionDescriptionSupplier> connectionDescriptionSupplierSet;

        @Inject
        public CompositeConnectionDescriptionSupplier(Set<ConnectionDescriptionSupplier> connectionDescriptionSupplierSet) {
            this.connectionDescriptionSupplierSet = connectionDescriptionSupplierSet;
        }

        @Override
        public Stream<ConnectionDescription> describeConnections() {
            return this.connectionDescriptionSupplierSet.stream().flatMap(ConnectionDescriptionSupplier::describeConnections);
        }
    }
}

