/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.util.Iterator;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface UsersDAO {
    default public boolean getDefaultVirtualHostingValue() {
        return false;
    }

    public Optional<? extends User> getUserByName(Username var1) throws UsersRepositoryException;

    public void updateUser(User var1) throws UsersRepositoryException;

    public void removeUser(Username var1) throws UsersRepositoryException;

    public boolean contains(Username var1) throws UsersRepositoryException;

    default public Publisher<Boolean> containsReactive(Username name) {
        return Mono.fromCallable(() -> this.contains(name)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    public int countUsers() throws UsersRepositoryException;

    public Iterator<Username> list() throws UsersRepositoryException;

    default public Publisher<Username> listReactive() {
        return Flux.fromIterable(() -> {
            try {
                return this.list();
            }
            catch (UsersRepositoryException e) {
                throw new RuntimeException(e);
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public void addUser(Username var1, String var2) throws UsersRepositoryException;
}

