/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IA5StringArgumentValueValidator
extends ArgumentValueValidator
implements Serializable {
    private static final long serialVersionUID = 7395996449791650693L;
    private final boolean allowEmptyStrings;

    public IA5StringArgumentValueValidator() {
        this(false);
    }

    public IA5StringArgumentValueValidator(boolean allowEmptyStrings) {
        this.allowEmptyStrings = allowEmptyStrings;
    }

    @Override
    public void validateArgumentValue(@NotNull Argument argument, @NotNull String valueString) throws ArgumentException {
        int length = valueString.length();
        if (length == 0 && !this.allowEmptyStrings) {
            throw new ArgumentException(ArgsMessages.ERR_IA5_STRING_VALIDATOR_EMPTY_STRING.get(argument.getIdentifierString()));
        }
        for (int i = 0; i < length; ++i) {
            int asciiByte;
            char c = valueString.charAt(i);
            if (c == (asciiByte = c & 0x7F)) continue;
            throw new ArgumentException(ArgsMessages.ERR_IA5_STRING_VALIDATOR_ILLEGAL_CHAR.get(valueString, argument.getIdentifierString(), String.valueOf(c), i));
        }
    }

    public boolean allowEmptyStrings() {
        return this.allowEmptyStrings;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("IA5StringArgumentValueValidator(allowEmptyStrings=");
        buffer.append(this.allowEmptyStrings);
        buffer.append(')');
    }
}

