/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.james.event.acl.ACLDTO;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.model.MailboxACL;

public class ACLDiffDTO {
    private final ACLDTO oldAcl;
    private final ACLDTO newAcl;

    public static ACLDiffDTO fromACLDiff(ACLDiff aclDiff) {
        return new ACLDiffDTO(ACLDTO.fromACL(aclDiff.getOldACL()), ACLDTO.fromACL(aclDiff.getNewACL()));
    }

    @JsonCreator
    public ACLDiffDTO(@JsonProperty(value="oldAcl") ACLDTO oldAcl, @JsonProperty(value="newAcl") ACLDTO newAcl) {
        this.oldAcl = oldAcl;
        this.newAcl = newAcl;
    }

    @JsonProperty(value="oldAcl")
    public ACLDTO getOldAcl() {
        return this.oldAcl;
    }

    @JsonProperty(value="newAcl")
    public ACLDTO getNewAcl() {
        return this.newAcl;
    }

    public ACLDiff asACLDiff() {
        return ACLDiff.computeDiff((MailboxACL)this.oldAcl.asACL(), (MailboxACL)this.newAcl.asACL());
    }

    public final boolean equals(Object o) {
        if (o instanceof ACLDiffDTO) {
            ACLDiffDTO that = (ACLDiffDTO)o;
            return Objects.equals(this.newAcl, that.newAcl) && Objects.equals(this.oldAcl, that.oldAcl);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.newAcl, this.oldAcl);
    }
}

