/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerDNSResponseListener;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.terms.GenericMechanism;

public class ExistsMechanism
extends GenericMechanism
implements SPFCheckerDNSResponseListener {
    public static final String REGEX = "[eE][xX][iI][sS][tT][sS]\\:((?:\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1})*(?:\\.(?:[a-zA-Z0-9]*[a-zA-Z]{1}[a-zA-Z0-9]*|(?:[a-zA-Z0-9]+\\-(?:[a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.?|\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)))";
    private SPFChecker expandedChecker = new ExpandedChecker();

    @Override
    public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        spfData.increaseCurrentDepth();
        spfData.pushChecker(this.expandedChecker);
        return this.macroExpand.checkExpand(this.getDomain(), spfData, false);
    }

    @Override
    public DNSLookupContinuation onDNSResponse(DNSResponse response, SPFSession spfSession) throws PermErrorException, TempErrorException {
        List<String> aRecords;
        try {
            aRecords = response.getResponse();
        }
        catch (TimeoutException e) {
            spfSession.setAttribute("Mechanism.result", Boolean.FALSE);
            return null;
        }
        if (aRecords != null && aRecords.size() > 0) {
            spfSession.setAttribute("Mechanism.result", Boolean.TRUE);
            return null;
        }
        spfSession.setAttribute("Mechanism.result", Boolean.FALSE);
        return null;
    }

    public String toString() {
        return "exists:" + this.getDomain();
    }

    private final class ExpandedChecker
    implements SPFChecker {
        private ExpandedChecker() {
        }

        @Override
        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            String host = ExistsMechanism.this.expandHost(spfData);
            return new DNSLookupContinuation(new DNSRequest(host, 1), ExistsMechanism.this);
        }
    }
}

