/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.mail.MessagingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.ExactNameCaseInsensitive;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.StorageDirective;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubAddressing
extends GenericMailet {
    private static final Logger LOG = LoggerFactory.getLogger(SubAddressing.class);
    private static final Username NO_ASSOCIATED_USER = null;
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;

    @Inject
    public SubAddressing(UsersRepository usersRepository, @Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
    }

    public void service(Mail mail) throws MessagingException {
        mail.getRecipients().forEach(recipient -> recipient.getLocalPartDetails("+").ifPresent(Throwing.consumer(targetFolder -> this.postIfHasRight(mail, recipient.stripDetails("+"), this.getPathWithCorrectCase((MailAddress)recipient, (String)targetFolder)))));
    }

    private Optional<MailboxPath> getPathWithCorrectCase(MailAddress recipient, String encodedTargetFolder) throws UsersRepositoryException, MailboxException {
        Username recipientUsername = this.usersRepository.getUsername(recipient);
        MailboxSession session = this.mailboxManager.createSystemSession(recipientUsername);
        String decodedTargetFolder = URLDecoder.decode(encodedTargetFolder, StandardCharsets.UTF_8);
        Comparator<MailboxPath> exactMatchFirst = Comparator.comparing(mailboxPath -> mailboxPath.getName().equals(decodedTargetFolder) ? 0 : 1);
        return this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).expression((MailboxNameExpression)new ExactNameCaseInsensitive(decodedTargetFolder)).build(), session).toStream().map(MailboxMetaData::getPath).sorted(exactMatchFirst).findFirst().or(() -> {
            LOG.info("{}'s subfolder `{}` was tried to be addressed but it does not exist", (Object)recipient, (Object)decodedTargetFolder);
            return Optional.empty();
        });
    }

    private void postIfHasRight(Mail mail, MailAddress recipient, Optional<MailboxPath> targetFolderPath) throws UsersRepositoryException, MailboxException {
        if (this.hasPostRight(mail, recipient, targetFolderPath).booleanValue()) {
            StorageDirective.builder().targetFolders((Collection)ImmutableList.of((Object)targetFolderPath.get().getName())).build().encodeAsAttributes(this.usersRepository.getUsername(recipient)).forEach(arg_0 -> ((Mail)mail).setAttribute(arg_0));
        } else {
            LOG.info("{} tried to address {}'s subfolder `{}` but they did not have the right to", new Object[]{mail.getMaybeSender().toString(), recipient, targetFolderPath});
        }
    }

    private Boolean hasPostRight(Mail mail, MailAddress recipient, Optional<MailboxPath> targetFolderPath) throws MailboxException, UsersRepositoryException {
        try {
            return targetFolderPath.isPresent() && this.resolvePostRight(this.retrieveMailboxACL(recipient, targetFolderPath.get()), mail.getMaybeSender(), recipient);
        }
        catch (MailboxNotFoundException e) {
            LOG.info("{}'s subfolder `{}` was tried to be addressed but it does not exist", (Object)recipient, targetFolderPath);
            return false;
        }
    }

    private MailboxACL retrieveMailboxACL(MailAddress recipient, MailboxPath targetFolderPath) throws MailboxException, UsersRepositoryException {
        Username recipientUsername = this.usersRepository.getUsername(recipient);
        MailboxSession session = this.mailboxManager.createSystemSession(recipientUsername);
        return this.mailboxManager.getMailbox(targetFolderPath, session).getMetaData(MessageManager.MailboxMetaData.RecentMode.IGNORE, session, MessageManager.MailboxMetaData.FetchGroup.NO_COUNT).getACL();
    }

    private boolean resolvePostRight(MailboxACL acl, MaybeSender maybeSender, MailAddress recipient) throws UnsupportedRightException, UsersRepositoryException {
        return new UnionMailboxACLResolver().resolveRights(maybeSender.asOptional().map(Throwing.function(arg_0 -> ((UsersRepository)this.usersRepository).getUsername(arg_0))).orElse(NO_ASSOCIATED_USER), acl, this.usersRepository.getUsername(recipient)).contains(MailboxACL.Right.Post);
    }
}

