/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.node.common;

import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.info.IDeviceInfo;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IInternalMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;

public class DeviceMNodeWrapper<N extends IMNode<N>, BasicNode extends IInternalMNode<N>>
implements IDeviceMNode<N> {
    protected final BasicNode basicMNode;

    public DeviceMNodeWrapper(BasicNode basicMNode) {
        this.basicMNode = basicMNode;
    }

    @Override
    public String getName() {
        return this.basicMNode.getName();
    }

    @Override
    public void setName(String name) {
        this.basicMNode.setName(name);
    }

    @Override
    public N getParent() {
        return this.basicMNode.getParent();
    }

    @Override
    public void setParent(N parent) {
        this.basicMNode.setParent(parent);
    }

    @Override
    public String getFullPath() {
        return this.basicMNode.getFullPath();
    }

    @Override
    public void setFullPath(String fullPath) {
        this.basicMNode.setFullPath(fullPath);
    }

    @Override
    public PartialPath getPartialPath() {
        return this.basicMNode.getPartialPath();
    }

    @Override
    public boolean hasChild(String name) {
        return this.basicMNode.hasChild(name);
    }

    @Override
    public N getChild(String name) {
        return this.basicMNode.getChild(name);
    }

    @Override
    public N addChild(String name, N child) {
        return this.basicMNode.addChild(name, child);
    }

    @Override
    public N addChild(N child) {
        return this.basicMNode.addChild(child);
    }

    @Override
    public N deleteChild(String name) {
        return this.basicMNode.deleteChild(name);
    }

    @Override
    public IMNodeContainer<N> getChildren() {
        return this.basicMNode.getChildren();
    }

    @Override
    public void setChildren(IMNodeContainer<N> children) {
        this.basicMNode.setChildren(children);
    }

    @Override
    public boolean isAboveDatabase() {
        return this.basicMNode.isAboveDatabase();
    }

    @Override
    public boolean isDatabase() {
        return this.basicMNode.isDatabase();
    }

    @Override
    public IDeviceInfo<N> getDeviceInfo() {
        return this.basicMNode.getDeviceInfo();
    }

    @Override
    public void setDeviceInfo(IDeviceInfo<N> deviceInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDevice() {
        return true;
    }

    @Override
    public MNodeType getMNodeType() {
        return MNodeType.DEVICE;
    }

    @Override
    public IDatabaseMNode<N> getAsDatabaseMNode() {
        return this.basicMNode.getAsDatabaseMNode();
    }

    @Override
    public IDeviceMNode<N> getAsDeviceMNode() {
        return this;
    }

    @Override
    public IInternalMNode<N> getAsInternalMNode() {
        return this.basicMNode;
    }

    @Override
    public IMeasurementMNode<N> getAsMeasurementMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitBasicMNode(this, context);
    }

    @Override
    public boolean addAlias(String alias, IMeasurementMNode<N> child) {
        return this.basicMNode.getDeviceInfo().addAlias(alias, child);
    }

    @Override
    public void deleteAliasChild(String alias) {
        this.basicMNode.getDeviceInfo().deleteAliasChild(alias);
    }

    @Override
    public Map<String, IMeasurementMNode<N>> getAliasChildren() {
        return this.basicMNode.getDeviceInfo().getAliasChildren();
    }

    @Override
    public void setAliasChildren(Map<String, IMeasurementMNode<N>> aliasChildren) {
        this.basicMNode.getDeviceInfo().setAliasChildren(aliasChildren);
    }

    @Override
    public boolean isUseTemplate() {
        return this.basicMNode.getDeviceInfo().isUseTemplate();
    }

    @Override
    public void setUseTemplate(boolean useTemplate) {
        this.basicMNode.getDeviceInfo().setUseTemplate(useTemplate);
    }

    @Override
    public void setSchemaTemplateId(int schemaTemplateId) {
        this.basicMNode.getDeviceInfo().setSchemaTemplateId(schemaTemplateId);
    }

    @Override
    public int getSchemaTemplateId() {
        return this.basicMNode.getDeviceInfo().getSchemaTemplateId();
    }

    @Override
    public int getSchemaTemplateIdWithState() {
        return this.basicMNode.getDeviceInfo().getSchemaTemplateIdWithState();
    }

    @Override
    public boolean isPreDeactivateSelfOrTemplate() {
        return this.basicMNode.getDeviceInfo().isPreDeactivateSelfOrTemplate();
    }

    @Override
    public void preDeactivateSelfOrTemplate() {
        this.basicMNode.getDeviceInfo().preDeactivateSelfOrTemplate();
    }

    @Override
    public void rollbackPreDeactivateSelfOrTemplate() {
        this.basicMNode.getDeviceInfo().rollbackPreDeactivateSelfOrTemplate();
    }

    @Override
    public void deactivateTemplate() {
        this.basicMNode.getDeviceInfo().deactivateTemplate();
    }

    @Override
    public boolean isAligned() {
        Boolean align = this.basicMNode.getDeviceInfo().isAligned();
        if (align == null) {
            return false;
        }
        return align;
    }

    @Override
    public Boolean isAlignedNullable() {
        return this.basicMNode.getDeviceInfo().isAligned();
    }

    @Override
    public void setAligned(Boolean isAligned) {
        this.basicMNode.getDeviceInfo().setAligned(isAligned);
    }

    @Override
    public int estimateSize() {
        return this.basicMNode.estimateSize();
    }

    @Override
    public N getAsMNode() {
        return this.basicMNode.getAsMNode();
    }
}

