/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.aggregation.TreeAggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractConsumeAllOperator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class AggregationOperator
extends AbstractConsumeAllOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AggregationOperator.class);
    private final ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;
    private final List<TreeAggregator> aggregators;
    private final TsBlockBuilder resultTsBlockBuilder;
    private final long maxRetainedSize;
    private final long childrenRetainedSize;
    private final boolean outputEndTime;

    public AggregationOperator(OperatorContext operatorContext, List<TreeAggregator> aggregators, ITimeRangeIterator timeRangeIterator, List<Operator> children, boolean outputEndTime, long maxReturnSize) {
        super(operatorContext, children);
        this.aggregators = aggregators;
        this.timeRangeIterator = timeRangeIterator;
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        if (outputEndTime) {
            dataTypes.add(TSDataType.INT64);
        }
        for (TreeAggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.resultTsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.childrenRetainedSize = children.stream().mapToLong(Operator::calculateRetainedSizeAfterCallingNext).sum();
        this.maxRetainedSize = this.childrenRetainedSize == 0L ? 0L : children.stream().mapToLong(Operator::calculateMaxReturnSize).sum();
        this.outputEndTime = outputEndTime;
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize + this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        while (System.nanoTime() - start < maxRuntime && (this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange()) && !this.resultTsBlockBuilder.isFull() && this.prepareInput()) {
            if (this.curTimeRange == null && this.timeRangeIterator.hasNextTimeRange()) {
                this.curTimeRange = this.timeRangeIterator.nextTimeRange();
                for (TreeAggregator aggregator : this.aggregators) {
                    aggregator.reset();
                }
            }
            this.calculateNextAggregationResult();
        }
        if (this.resultTsBlockBuilder.getPositionCount() > 0) {
            TsBlock resultTsBlock = this.resultTsBlockBuilder.build();
            this.resultTsBlockBuilder.reset();
            return resultTsBlock;
        }
        return null;
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    private void calculateNextAggregationResult() {
        for (TreeAggregator aggregator : this.aggregators) {
            aggregator.processTsBlocks(this.inputTsBlocks);
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.inputTsBlocks[i] = this.inputTsBlocks[i].skipFirst();
            if (!this.inputTsBlocks[i].isEmpty()) continue;
            this.inputTsBlocks[i] = null;
        }
        this.updateResultTsBlock();
    }

    private void updateResultTsBlock() {
        if (!this.outputEndTime) {
            AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime());
        } else {
            AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime(), this.curTimeRange.getMax());
        }
        this.curTimeRange = null;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.canCallNext) + this.resultTsBlockBuilder.getRetainedSizeInBytes();
    }
}

