/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair;

import org.apache.iotdb.library.drepair.util.TimestampRepair;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFTimestampRepair
implements UDTF {
    String intervalMethod;
    long interval;
    long intervalMode;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64);
        String intervalString = validator.getParameters().getStringOrDefault("interval", null);
        if (intervalString != null) {
            try {
                this.interval = Long.parseLong(intervalString);
            }
            catch (NumberFormatException e) {
                try {
                    this.interval = Util.parseTime(intervalString, validator.getParameters());
                }
                catch (Exception ex) {
                    throw new UDFException("Invalid time format for interval.");
                }
            }
            validator.validate(x -> this.interval > 0L, "Invalid time unit input. Supported units are ns, us, ms, s, m, h, d.", new Object[0]);
        }
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new SlidingSizeWindowAccessStrategy(Integer.MAX_VALUE)).setOutputDataType(parameters.getDataType(0));
        this.intervalMethod = parameters.getStringOrDefault("method", "Median");
        String intervalString = parameters.getStringOrDefault("interval", null);
        if (intervalString != null) {
            try {
                this.interval = Long.parseLong(intervalString);
            }
            catch (NumberFormatException e) {
                this.interval = Util.parseTime(intervalString, parameters);
            }
        } else {
            this.interval = 0L;
        }
        if (this.interval > 0L) {
            this.intervalMode = this.interval;
        } else if ("Median".equalsIgnoreCase(this.intervalMethod)) {
            this.intervalMode = -1L;
        } else if ("Mode".equalsIgnoreCase(this.intervalMethod)) {
            this.intervalMode = -2L;
        } else if ("Cluster".equalsIgnoreCase(this.intervalMethod)) {
            this.intervalMode = -3L;
        } else {
            throw new UDFException("Illegal method.");
        }
    }

    @Override
    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        TimestampRepair ts = new TimestampRepair(rowWindow.getRowIterator(), this.intervalMode, 2);
        ts.dpRepair();
        long[] timestamp = ts.getRepaired();
        double[] value = ts.getRepairedValue();
        switch (rowWindow.getDataType(0)) {
            case DOUBLE: {
                for (int i = 0; i < timestamp.length; ++i) {
                    collector.putDouble(timestamp[i], value[i]);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < timestamp.length; ++i) {
                    collector.putFloat(timestamp[i], (float)value[i]);
                }
                break;
            }
            case INT32: {
                for (int i = 0; i < timestamp.length; ++i) {
                    collector.putInt(timestamp[i], (int)value[i]);
                }
                break;
            }
            case INT64: {
                for (int i = 0; i < timestamp.length; ++i) {
                    collector.putLong(timestamp[i], (long)value[i]);
                }
                break;
            }
            default: {
                throw new UDFException("");
            }
        }
    }
}

