/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.iotdb.db.protocol.mqtt;

import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.utils.EnvironmentUtils;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.io.IOException;

public class BrokerAuthenticatorTest {

  @Before
  public void before() {
    EnvironmentUtils.envSetUp();
  }

  @After
  public void after() throws IOException, StorageEngineException {
    EnvironmentUtils.cleanEnv();
  }

  @Test
  public void checkValid() {
    // In the previous implementation, the datanode will init a root file,
    // but now checkuser operation needs to link to confignode.
    //    BrokerAuthenticator authenticator = new BrokerAuthenticator();
    //    assertTrue(authenticator.checkValid(null, "root", "root".getBytes()));
    //    assertFalse(authenticator.checkValid(null, "", "foo".getBytes()));
    //    assertFalse(authenticator.checkValid(null, "root", null));
    //    assertFalse(authenticator.checkValid(null, "foo", "foo".getBytes()));
  }
}
