/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iotdb.confignode.consensus.response.trigger;

import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.rpc.thrift.TGetLocationForTriggerResp;
import org.apache.iotdb.consensus.common.DataSet;

public class TriggerLocationResp implements DataSet {

  private final TSStatus status;

  private final TDataNodeLocation dataNodeLocation;

  public TriggerLocationResp(TSStatus status, TDataNodeLocation dataNodeLocation) {
    this.status = status;
    this.dataNodeLocation = dataNodeLocation;
  }

  @TestOnly
  public TSStatus getStatus() {
    return status;
  }

  @TestOnly
  public TDataNodeLocation getDataNodeLocation() {
    return dataNodeLocation;
  }

  public TGetLocationForTriggerResp convertToThriftResponse() {
    return new TGetLocationForTriggerResp(status).setDataNodeLocation(dataNodeLocation);
  }
}
