/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import org.apache.iotdb.library.drepair.util.ValueFill;
import org.apache.iotdb.udf.api.access.RowIterator;
import org.apache.iotdb.udf.api.exception.UDFException;

public class ARFill
extends ValueFill {
    private double theta = 1.0E10;

    public ARFill(RowIterator dataIterator) throws Exception {
        super(dataIterator);
        this.calMeanAndVar();
    }

    @Override
    public void fill() throws UDFException {
        int i;
        double acf = 0.0;
        double factor = 0.0;
        for (int i2 = 0; i2 < this.original.length - 1; ++i2) {
            double left = this.original[i2];
            double right = this.original[i2 + 1];
            if (Double.isNaN(left)) {
                left = 0.0;
            }
            if (Double.isNaN(right)) {
                right = 0.0;
            }
            acf += left * right;
            factor += left * left;
        }
        if (factor == 0.0 || this.theta >= 1.0) {
            this.time = new long[]{0L};
            this.repaired = new double[]{0.0};
            throw new UDFException("Cannot fit AR(1) model. Please try another method.");
        }
        this.theta = acf / factor;
        double meanEpsilon = 0.0;
        double cntEpsilon = 0.0;
        for (i = 0; i < this.original.length - 1; ++i) {
            double left = this.original[i];
            double right = this.original[i + 1];
            if (Double.isNaN(left) || Double.isNaN(right)) continue;
            cntEpsilon += 1.0;
            double epsilon = right - left * this.theta;
            meanEpsilon += epsilon;
        }
        if (cntEpsilon == 0.0) {
            this.time = new long[]{0L};
            this.repaired = new double[]{0.0};
            throw new UDFException("Cannot fit AR(1) model. Please try another method.");
        }
        meanEpsilon /= cntEpsilon;
        for (i = 0; i < this.original.length; ++i) {
            double yt = this.original[i];
            this.repaired[i] = !Double.isNaN(yt) ? yt : (i != 0 ? this.theta * this.repaired[i - 1] + meanEpsilon : this.mean);
        }
    }
}

