/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.type;

import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.FloatColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;

public class FloatType
implements Type {
    private static final FloatType INSTANCE = new FloatType();

    private FloatType() {
    }

    @Override
    public int getInt(Column c, int position) {
        return (int)c.getFloat(position);
    }

    @Override
    public long getLong(Column c, int position) {
        return (long)c.getFloat(position);
    }

    @Override
    public float getFloat(Column c, int position) {
        return c.getFloat(position);
    }

    @Override
    public double getDouble(Column c, int position) {
        return c.getFloat(position);
    }

    @Override
    public void writeInt(ColumnBuilder builder, int value) {
        builder.writeFloat((float)value);
    }

    @Override
    public void writeLong(ColumnBuilder builder, long value) {
        builder.writeFloat((float)value);
    }

    @Override
    public void writeFloat(ColumnBuilder builder, float value) {
        builder.writeFloat(value);
    }

    @Override
    public void writeDouble(ColumnBuilder builder, double value) {
        builder.writeFloat((float)value);
    }

    @Override
    public ColumnBuilder createColumnBuilder(int expectedEntries) {
        return new FloatColumnBuilder(null, expectedEntries);
    }

    @Override
    public TypeEnum getTypeEnum() {
        return TypeEnum.FLOAT;
    }

    public static FloatType getInstance() {
        return INSTANCE;
    }
}

