/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class Chunk {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(Chunk.class) + ChunkHeader.INSTANCE_SIZE + RamUsageEstimator.shallowSizeOfInstance(ByteBuffer.class);
    private final ChunkHeader chunkHeader;
    private ByteBuffer chunkData;
    private Statistics chunkStatistic;
    private List<TimeRange> deleteIntervalList;

    public Chunk(ChunkHeader header, ByteBuffer buffer, List<TimeRange> deleteIntervalList, Statistics chunkStatistic) {
        this.chunkHeader = header;
        this.chunkData = buffer;
        this.deleteIntervalList = deleteIntervalList;
        this.chunkStatistic = chunkStatistic;
    }

    public Chunk(ChunkHeader header, ByteBuffer buffer) {
        this.chunkHeader = header;
        this.chunkData = buffer;
    }

    public ChunkHeader getHeader() {
        return this.chunkHeader;
    }

    public ByteBuffer getData() {
        return this.chunkData;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public void mergeChunkByAppendPage(Chunk chunk) throws IOException {
        PublicBAOS a;
        byte[] b;
        int dataSize = 0;
        int offset1 = -1;
        if ((byte)(chunk.chunkHeader.getChunkType() & 0x3F) == 5) {
            ReadWriteForEncodingUtils.readUnsignedVarInt(chunk.chunkData);
            ReadWriteForEncodingUtils.readUnsignedVarInt(chunk.chunkData);
            offset1 = chunk.chunkData.position();
            chunk.chunkData.flip();
            dataSize += chunk.chunkData.array().length + chunk.chunkStatistic.getSerializedSize();
        } else {
            dataSize += chunk.chunkData.array().length;
        }
        int offset2 = -1;
        if ((byte)(this.chunkHeader.getChunkType() & 0x3F) == 5) {
            this.chunkHeader.setChunkType((byte)1);
            ReadWriteForEncodingUtils.readUnsignedVarInt(this.chunkData);
            ReadWriteForEncodingUtils.readUnsignedVarInt(this.chunkData);
            offset2 = this.chunkData.position();
            this.chunkData.flip();
            dataSize += this.chunkData.array().length + this.chunkStatistic.getSerializedSize();
        } else {
            dataSize += this.chunkData.array().length;
        }
        this.chunkHeader.setDataSize(dataSize);
        ByteBuffer newChunkData = ByteBuffer.allocate(dataSize);
        if (offset2 == -1) {
            newChunkData.put(this.chunkData.array());
        } else {
            b = this.chunkData.array();
            newChunkData.put(b, 0, offset2);
            a = new PublicBAOS();
            this.chunkStatistic.serialize(a);
            newChunkData.put(a.getBuf(), 0, a.size());
            newChunkData.put(b, offset2, b.length - offset2);
        }
        if (offset1 == -1) {
            newChunkData.put(chunk.chunkData.array());
        } else {
            b = chunk.chunkData.array();
            newChunkData.put(b, 0, offset1);
            a = new PublicBAOS();
            chunk.chunkStatistic.serialize(a);
            newChunkData.put(a.getBuf(), 0, a.size());
            newChunkData.put(b, offset1, b.length - offset1);
        }
        this.chunkData = newChunkData;
    }

    public Statistics getChunkStatistic() {
        return this.chunkStatistic;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOfByteArray((int)this.chunkData.capacity());
    }

    public boolean isSinglePageChunk() {
        return (this.getHeader().getChunkType() & 0x3F) == 5;
    }
}

