/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.fileSystem.fsFactory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.fileSystem.FSType;
import org.apache.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSFSFactory
implements FSFactory {
    private static final Logger logger = LoggerFactory.getLogger(OSFSFactory.class);
    private Constructor constructorWithPathname;
    private Constructor constructorWithParentStringAndChild;
    private Constructor constructorWithParentFileAndChild;
    private Constructor constructorWithUri;
    private Method getBufferedReader;
    private Method getBufferedWriter;
    private Method getBufferedInputStream;
    private Method getBufferedOutputStream;
    private Method listFilesBySuffix;
    private Method listFilesByPrefix;
    private Method renameTo;
    private Method putFile;
    private Method copyTo;
    private Method deleteObjectsByPrefix;

    public OSFSFactory() {
        try {
            Class<?> clazz = Class.forName(TSFileDescriptor.getInstance().getConfig().getObjectStorageFile());
            this.constructorWithPathname = clazz.getConstructor(String.class);
            this.constructorWithParentStringAndChild = clazz.getConstructor(String.class, String.class);
            this.constructorWithParentFileAndChild = clazz.getConstructor(File.class, String.class);
            this.constructorWithUri = clazz.getConstructor(URI.class);
            this.getBufferedReader = clazz.getMethod("getBufferedReader", new Class[0]);
            this.getBufferedWriter = clazz.getMethod("getBufferedWriter", Boolean.TYPE);
            this.getBufferedInputStream = clazz.getMethod("getBufferedInputStream", new Class[0]);
            this.getBufferedOutputStream = clazz.getMethod("getBufferedOutputStream", new Class[0]);
            this.listFilesBySuffix = clazz.getMethod("listFilesBySuffix", String.class, String.class);
            this.listFilesByPrefix = clazz.getMethod("listFilesByPrefix", String.class, String.class);
            this.renameTo = clazz.getMethod("renameTo", File.class);
            this.putFile = clazz.getMethod("putFile", File.class);
            this.copyTo = clazz.getMethod("copyTo", File.class);
            this.deleteObjectsByPrefix = clazz.getMethod("deleteObjectsByPrefix", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get object storage. Please check your dependency of object storage module.", (Throwable)e);
        }
    }

    @Override
    public File getFileWithParent(String pathname) {
        try {
            return (File)this.constructorWithPathname.newInstance(pathname);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of object storage module.", (Object)pathname, (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(String pathname) {
        try {
            return (File)this.constructorWithPathname.newInstance(pathname);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)pathname, (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(String parent, String child) {
        try {
            return (File)this.constructorWithParentStringAndChild.newInstance(parent, child);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)(parent + File.separator + child), (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(File parent, String child) {
        try {
            return (File)this.constructorWithParentFileAndChild.newInstance(parent, child);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)(parent.getAbsolutePath() + File.separator + child), (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(URI uri) {
        try {
            return (File)this.constructorWithUri.newInstance(uri);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of object storage module.", (Object)uri, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedReader getBufferedReader(String filePath) {
        try {
            return (BufferedReader)this.getBufferedReader.invoke(this.constructorWithPathname.newInstance(filePath), new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered reader for {}. Please check your dependency of object storage module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedWriter getBufferedWriter(String filePath, boolean append) {
        try {
            return (BufferedWriter)this.getBufferedWriter.invoke(this.constructorWithPathname.newInstance(filePath), append);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered writer for {}. Please check your dependency of object storage module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedInputStream getBufferedInputStream(String filePath) {
        try {
            return (BufferedInputStream)this.getBufferedInputStream.invoke(this.constructorWithPathname.newInstance(filePath), new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered input stream for {}. Please check your dependency of object storage module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream(String filePath) {
        try {
            return (BufferedOutputStream)this.getBufferedOutputStream.invoke(this.constructorWithPathname.newInstance(filePath), new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered output stream for {}. Please check your dependency of object storage module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public void moveFile(File srcFile, File destFile) throws IOException {
        try {
            this.renameTo.invoke((Object)srcFile, destFile);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void copyFile(File srcFile, File destFile) throws IOException {
        block4: {
            FSType srcType = FSUtils.getFSType(srcFile);
            try {
                if (srcType == FSType.LOCAL) {
                    this.putFile.invoke((Object)destFile, srcFile);
                    break block4;
                }
                if (srcType == FSType.OBJECT_STORAGE) {
                    this.copyTo.invoke((Object)srcFile, destFile);
                    break block4;
                }
                throw new IOException(String.format("Doesn't support copy file from %s to %s.", new Object[]{srcType, FSType.OBJECT_STORAGE}));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public File[] listFilesBySuffix(String fileFolder, String suffix) {
        try {
            return (File[])this.listFilesBySuffix.invoke(this.constructorWithPathname.newInstance(fileFolder), fileFolder, suffix);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to list files in {} with SUFFIX {}. Please check your dependency of object storage module.", new Object[]{fileFolder, suffix, e});
            return null;
        }
    }

    @Override
    public File[] listFilesByPrefix(String fileFolder, String prefix) {
        try {
            return (File[])this.listFilesByPrefix.invoke(this.constructorWithPathname.newInstance(fileFolder), fileFolder, prefix);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to list files in {} with PREFIX {}. Please check your dependency of object storage module.", new Object[]{fileFolder, prefix, e});
            return null;
        }
    }

    @Override
    public boolean deleteIfExists(File file) {
        return file.delete();
    }

    @Override
    public void deleteDirectory(String dir) throws IOException {
        try {
            this.deleteObjectsByPrefix.invoke(this.constructorWithPathname.newInstance(dir), new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }
}

