/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.fileSystem.fsFactory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.fileSystem.FSType;
import org.apache.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSFactory
implements FSFactory {
    private static final Logger logger = LoggerFactory.getLogger(HDFSFactory.class);
    private Constructor constructorWithPathname;
    private Constructor constructorWithParentStringAndChild;
    private Constructor constructorWithParentFileAndChild;
    private Constructor constructorWithUri;
    private Method getBufferedReader;
    private Method getBufferedWriter;
    private Method getBufferedInputStream;
    private Method getBufferedOutputStream;
    private Method listFilesBySuffix;
    private Method listFilesByPrefix;
    private Method renameTo;
    private Method copyToLocal;
    private Method copyFromLocal;
    private Method copyTo;

    public HDFSFactory() {
        try {
            Class<?> clazz = Class.forName(TSFileDescriptor.getInstance().getConfig().getHdfsFile());
            this.constructorWithPathname = clazz.getConstructor(String.class);
            this.constructorWithParentStringAndChild = clazz.getConstructor(String.class, String.class);
            this.constructorWithParentFileAndChild = clazz.getConstructor(File.class, String.class);
            this.constructorWithUri = clazz.getConstructor(URI.class);
            this.getBufferedReader = clazz.getMethod("getBufferedReader", String.class);
            this.getBufferedWriter = clazz.getMethod("getBufferedWriter", String.class, Boolean.TYPE);
            this.getBufferedInputStream = clazz.getMethod("getBufferedInputStream", String.class);
            this.getBufferedOutputStream = clazz.getMethod("getBufferedOutputStream", String.class);
            this.listFilesBySuffix = clazz.getMethod("listFilesBySuffix", String.class, String.class);
            this.listFilesByPrefix = clazz.getMethod("listFilesByPrefix", String.class, String.class);
            this.renameTo = clazz.getMethod("renameTo", File.class);
            this.copyToLocal = clazz.getMethod("copyToLocal", File.class);
            this.copyFromLocal = clazz.getMethod("copyFromLocal", File.class);
            this.copyTo = clazz.getMethod("copyTo", File.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get Hadoop file system. Please check your dependency of Hadoop module.", (Throwable)e);
        }
    }

    @Override
    public File getFileWithParent(String pathname) {
        try {
            File res = (File)this.constructorWithPathname.newInstance(pathname);
            if (!res.exists()) {
                res.getParentFile().mkdirs();
            }
            return res;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)pathname, (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(String pathname) {
        try {
            return (File)this.constructorWithPathname.newInstance(pathname);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)pathname, (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(String parent, String child) {
        try {
            return (File)this.constructorWithParentStringAndChild.newInstance(parent, child);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)(parent + File.separator + child), (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(File parent, String child) {
        try {
            return (File)this.constructorWithParentFileAndChild.newInstance(parent, child);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)(parent.getAbsolutePath() + File.separator + child), (Object)e);
            return null;
        }
    }

    @Override
    public File getFile(URI uri) {
        try {
            return (File)this.constructorWithUri.newInstance(uri);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get file: {}. Please check your dependency of Hadoop module.", (Object)uri, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedReader getBufferedReader(String filePath) {
        try {
            return (BufferedReader)this.getBufferedReader.invoke(this.constructorWithPathname.newInstance(filePath), filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered reader for {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedWriter getBufferedWriter(String filePath, boolean append) {
        try {
            return (BufferedWriter)this.getBufferedWriter.invoke(this.constructorWithPathname.newInstance(filePath), filePath, append);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered writer for {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedInputStream getBufferedInputStream(String filePath) {
        try {
            return (BufferedInputStream)this.getBufferedInputStream.invoke(this.constructorWithPathname.newInstance(filePath), filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered input stream for {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public BufferedOutputStream getBufferedOutputStream(String filePath) {
        try {
            return (BufferedOutputStream)this.getBufferedOutputStream.invoke(this.constructorWithPathname.newInstance(filePath), filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get buffered output stream for {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    @Override
    public void moveFile(File srcFile, File destFile) throws IOException {
        try {
            this.renameTo.invoke(this.constructorWithPathname.newInstance(srcFile.getAbsolutePath()), destFile);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void copyFile(File srcFile, File destFile) throws IOException {
        FSType srcType = FSUtils.getFSType(srcFile);
        FSType destType = FSUtils.getFSType(destFile);
        try {
            if (srcType == FSType.HDFS && destType == FSType.HDFS) {
                this.copyTo.invoke(this.constructorWithPathname.newInstance(srcFile.getAbsolutePath()), destFile);
            } else if (srcType == FSType.LOCAL) {
                this.copyFromLocal.invoke(this.constructorWithPathname.newInstance(destFile.getAbsolutePath()), srcFile);
            } else {
                this.copyToLocal.invoke(this.constructorWithPathname.newInstance(srcFile.getAbsolutePath()), destFile);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    @Override
    public File[] listFilesBySuffix(String fileFolder, String suffix) {
        try {
            return (File[])this.listFilesBySuffix.invoke(this.constructorWithPathname.newInstance(fileFolder), fileFolder, suffix);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to list files in {} with SUFFIX {}. Please check your dependency of Hadoop module.", new Object[]{fileFolder, suffix, e});
            return null;
        }
    }

    @Override
    public File[] listFilesByPrefix(String fileFolder, String prefix) {
        try {
            return (File[])this.listFilesByPrefix.invoke(this.constructorWithPathname.newInstance(fileFolder), fileFolder, prefix);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to list files in {} with PREFIX {}. Please check your dependency of Hadoop module.", new Object[]{fileFolder, prefix, e});
            return null;
        }
    }

    @Override
    public boolean deleteIfExists(File file) {
        return file.delete();
    }

    @Override
    public void deleteDirectory(String dir) throws IOException {
        this.getFile(dir).delete();
    }
}

