/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.fileSystem.fileOutputFactory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tsfile.fileSystem.fileOutputFactory.FileOutputFactory;
import org.apache.tsfile.write.writer.LocalTsFileOutput;
import org.apache.tsfile.write.writer.TsFileOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFSOutputFactory
implements FileOutputFactory {
    private static final Logger logger = LoggerFactory.getLogger(LocalFSOutputFactory.class);

    @Override
    public TsFileOutput getTsFileOutput(String filePath, boolean append) {
        try {
            File file = new File(filePath);
            File parentDirectory = file.getParentFile();
            if (parentDirectory != null) {
                file.getParentFile().mkdirs();
            }
            return new LocalTsFileOutput(new FileOutputStream(file, append));
        }
        catch (IOException e) {
            logger.error("Failed to get TsFile output of file: {}, ", (Object)filePath, (Object)e);
            return null;
        }
    }
}

