/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.filter.StatisticsClassException;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class BlobStatistics
extends Statistics<Binary> {
    public static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(BlobStatistics.class);

    @Override
    public TSDataType getType() {
        return TSDataType.BLOB;
    }

    @Override
    public int getStatsSize() {
        return 0;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    @Override
    int serializeStats(OutputStream outputStream) throws IOException {
        return 0;
    }

    @Override
    public void updateStats(Binary value) {
        if (this.isEmpty) {
            this.isEmpty = false;
        }
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
    }

    @Override
    public Binary getMinValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TSDataType.BLOB, "min"));
    }

    @Override
    public Binary getMaxValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TSDataType.BLOB, "max"));
    }

    @Override
    public Binary getFirstValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TSDataType.BLOB, "first"));
    }

    @Override
    public Binary getLastValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TSDataType.BLOB, "last"));
    }

    @Override
    public double getSumDoubleValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TSDataType.BLOB, "sum"));
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", TSDataType.BLOB, "sum"));
    }

    @Override
    protected void mergeStatisticsValue(Statistics<Binary> stats) {
        if (this.isEmpty) {
            this.isEmpty = false;
        }
    }

    @Override
    public String toString() {
        return "BlobStatistics{}";
    }
}

