/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata.enums;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public enum MetadataIndexNodeType {
    INTERNAL_DEVICE(0),
    LEAF_DEVICE(1),
    INTERNAL_MEASUREMENT(2),
    LEAF_MEASUREMENT(3);

    private final byte type;

    private MetadataIndexNodeType(byte type) {
        this.type = type;
    }

    public static MetadataIndexNodeType deserialize(byte i) {
        switch (i) {
            case 0: {
                return INTERNAL_DEVICE;
            }
            case 1: {
                return LEAF_DEVICE;
            }
            case 2: {
                return INTERNAL_MEASUREMENT;
            }
            case 3: {
                return LEAF_MEASUREMENT;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + i);
    }

    public static MetadataIndexNodeType deserializeFrom(ByteBuffer buffer) {
        return MetadataIndexNodeType.deserialize(buffer.get());
    }

    public static int getSerializedSize() {
        return 1;
    }

    public void serializeTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.serialize());
    }

    public void serializeTo(DataOutputStream outputStream) throws IOException {
        outputStream.write(this.serialize());
    }

    public byte serialize() {
        return this.type;
    }
}

