/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;

public abstract class UDTFEqualSizeBucketSample
implements UDTF {
    protected TSDataType dataType;
    protected double proportion;
    protected int bucketSize;

    public void validate(UDFParameterValidator validator) throws MetadataException, UDFException {
        this.proportion = validator.getParameters().getDoubleOrDefault("proportion", 0.1);
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, new Type[]{Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE}).validate(proportion -> (Double)proportion > 0.0 && (Double)proportion <= 1.0, "Illegal sample proportion. proportion > 0 and proportion <= 1", (Object)this.proportion);
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(validator.getParameters().getDataType(0));
        this.bucketSize = (int)(1.0 / this.proportion);
    }
}

