/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.resource.ref;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipePhantomReferenceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePhantomReferenceManager.class);
    private static final Set<PipeEventPhantomReference> PIPE_EVENT_PHANTOM_REFERENCES = ConcurrentHashMap.newKeySet();
    private static final ReferenceQueue<EnrichedEvent> REFERENCE_QUEUE = new ReferenceQueue();
    private volatile long lastPhantomReferenceCount = -1L;

    public int getPhantomReferenceCount() {
        return PIPE_EVENT_PHANTOM_REFERENCES.size();
    }

    protected void gcHook() {
        int count;
        if (!PipeConfig.getInstance().getPipeEventReferenceTrackingEnabled()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        int maxCount = this.getPhantomReferenceCount();
        try {
            Reference<EnrichedEvent> reference;
            for (count = 0; count < maxCount && (reference = REFERENCE_QUEUE.remove(500L)) != null; ++count) {
                this.finalizeResource((PipeEventPhantomReference)reference);
            }
        }
        catch (InterruptedException e) {
            Reference<EnrichedEvent> reference;
            while (count < maxCount && (reference = REFERENCE_QUEUE.poll()) != null) {
                this.finalizeResource((PipeEventPhantomReference)reference);
                ++count;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (count != 0) {
            LOGGER.info("Clean {} pipe phantom reference(s) successfully within {} ms, remaining reference count: {}", new Object[]{count, System.currentTimeMillis() - startTime, this.getPhantomReferenceCount()});
        } else {
            long currentPhantomReferenceCount = this.getPhantomReferenceCount();
            if (currentPhantomReferenceCount != this.lastPhantomReferenceCount) {
                if (this.lastPhantomReferenceCount != -1L) {
                    LOGGER.info("Remaining pipe phantom reference count: {}", (Object)currentPhantomReferenceCount);
                }
                this.lastPhantomReferenceCount = currentPhantomReferenceCount;
            }
        }
    }

    private void finalizeResource(PipeEventPhantomReference reference) {
        try {
            reference.finalizeResources();
            reference.clear();
        }
        finally {
            PIPE_EVENT_PHANTOM_REFERENCES.remove(reference);
        }
    }

    public void trackPipeEventResource(EnrichedEvent event, PipeEventResource resource) {
        PipeEventPhantomReference reference = new PipeEventPhantomReference(event, resource, REFERENCE_QUEUE);
        PIPE_EVENT_PHANTOM_REFERENCES.add(reference);
    }

    private static class PipeEventPhantomReference
    extends PhantomReference<EnrichedEvent> {
        private final String holderMessage;
        private PipeEventResource resource;

        private PipeEventPhantomReference(EnrichedEvent event, PipeEventResource resource, ReferenceQueue<? super EnrichedEvent> queue) {
            super(event, queue);
            this.holderMessage = event.getClass().getSimpleName();
            this.resource = resource;
        }

        private void finalizeResources() {
            if (this.resource != null) {
                try {
                    this.resource.clearReferenceCount(this.holderMessage);
                }
                finally {
                    this.resource = null;
                }
            }
        }
    }

    public static abstract class PipeEventResource {
        private final AtomicBoolean isReleased;
        private final AtomicInteger referenceCount;

        protected PipeEventResource(AtomicBoolean isReleased, AtomicInteger referenceCount) {
            this.isReleased = isReleased;
            this.referenceCount = referenceCount;
        }

        private void clearReferenceCount(String holderMessage) {
            if (this.isReleased.get()) {
                return;
            }
            if (this.referenceCount.get() >= 1) {
                LOGGER.error("PIPE EVENT RESOURCE LEAK DETECTED ({}): {}", (Object)this.referenceCount, (Object)holderMessage);
                this.finalizeResource();
            }
            this.referenceCount.set(0);
            this.isReleased.set(true);
        }

        protected abstract void finalizeResource();
    }
}

