/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.execution;

import org.apache.iotdb.commons.pipe.agent.task.execution.PipeSubtaskExecutor;
import org.apache.iotdb.commons.pipe.config.PipeConfig;

public class PipeSubtaskScheduler {
    private static final PipeConfig PIPE_CONFIG = PipeConfig.getInstance();
    private final PipeSubtaskExecutor executor;
    private boolean isFirstSchedule = true;
    private int consumedEventCountCheckpointInterval;
    private int consumedEventCount;
    private long timeDurationCheckpointInterval;
    private long lastCheckTime;

    public PipeSubtaskScheduler(PipeSubtaskExecutor executor) {
        this.executor = executor;
    }

    public boolean schedule() {
        if (this.isFirstSchedule) {
            this.isFirstSchedule = false;
            this.adjustCheckpointIntervalBasedOnExecutorStatus();
            ++this.consumedEventCount;
            return true;
        }
        if (this.consumedEventCount < this.consumedEventCountCheckpointInterval && System.currentTimeMillis() - this.lastCheckTime < this.timeDurationCheckpointInterval) {
            ++this.consumedEventCount;
            return true;
        }
        return false;
    }

    private void adjustCheckpointIntervalBasedOnExecutorStatus() {
        this.consumedEventCount = 0;
        this.lastCheckTime = System.currentTimeMillis();
        int corePoolSize = Math.max(1, this.executor.getCorePoolSize());
        int runningSubtaskNumber = Math.max(1, this.executor.getRunningSubtaskNumber());
        this.consumedEventCountCheckpointInterval = Math.max(1, (int)((float)PIPE_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount() / (float)runningSubtaskNumber * (float)corePoolSize));
        this.timeDurationCheckpointInterval = Math.max(1L, (long)((float)PIPE_CONFIG.getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration() / (float)runningSubtaskNumber * (float)corePoolSize));
    }

    public void reset() {
        this.isFirstSchedule = true;
    }
}

