/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.plugin.service;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.pipe.agent.plugin.service.PipePluginClassLoader;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;

@NotThreadSafe
public class PipePluginClassLoaderManager
implements IService {
    private final String libRoot;
    private final Map<String, PipePluginClassLoader> pipePluginNameToClassLoaderMap;
    private static PipePluginClassLoaderManager instance = null;

    private PipePluginClassLoaderManager(String libRoot) throws IOException {
        this.libRoot = libRoot;
        this.pipePluginNameToClassLoaderMap = new ConcurrentHashMap<String, PipePluginClassLoader>();
    }

    public void removePluginClassLoader(String pluginName) throws IOException {
        PipePluginClassLoader classLoader = this.pipePluginNameToClassLoaderMap.remove(pluginName.toUpperCase());
        if (classLoader != null) {
            classLoader.markAsDeprecated();
        }
    }

    public PipePluginClassLoader getPluginClassLoader(String pluginName) {
        return this.pipePluginNameToClassLoaderMap.get(pluginName.toUpperCase());
    }

    public void addPluginAndClassLoader(String pluginName, PipePluginClassLoader classLoader) {
        this.pipePluginNameToClassLoaderMap.put(pluginName.toUpperCase(), classLoader);
    }

    public PipePluginClassLoader createPipePluginClassLoader(String pluginDirPath) throws IOException {
        return new PipePluginClassLoader(pluginDirPath);
    }

    @Override
    public void start() throws StartupException {
        try {
            SystemFileFactory.INSTANCE.makeDirIfNecessary(this.libRoot);
        }
        catch (IOException e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.PIPE_PLUGIN_CLASSLOADER_MANAGER_SERVICE;
    }

    public static synchronized PipePluginClassLoaderManager setupAndGetInstance(String libRoot) throws IOException {
        if (instance == null) {
            instance = new PipePluginClassLoaderManager(libRoot);
        }
        return instance;
    }

    public static PipePluginClassLoaderManager getInstance() {
        return instance;
    }
}

