/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.type.ExitType;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.schema.AbstractSchemaTool;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.jline.reader.LineReader;

public class ExportSchema
extends AbstractSchemaTool {
    private static final String TARGET_DIR_ARGS = "t";
    private static final String TARGET_DIR_ARGS_NAME = "target";
    private static final String TARGET_DIR_NAME = "targetDir";
    private static final String TARGET_PATH_ARGS = "path";
    private static final String TARGET_PATH_ARGS_NAME = "path_pattern";
    private static final String TARGET_PATH_NAME = "exportPathPattern";
    private static String queryPath;
    private static final String TARGET_FILE_ARGS = "pf";
    private static final String TARGET_FILE_ARGS_NAME = "path_pattern_file";
    private static final String TARGET_FILE_NAME = "exportPathPatternFile";
    private static final String LINES_PER_FILE_ARGS = "lpf";
    private static final String LINES_PER_FILE_ARGS_NAME = "lines_per_file";
    private static final String LINES_PER_FILE_NAME = "linesPerFile";
    private static int linesPerFile;
    private static final String EXPORT_SCHEMA_CLI_PREFIX = "ExportSchema";
    private static final String DUMP_FILE_NAME_DEFAULT = "dump";
    private static String targetFile;
    private static String targetDirectory;
    private static long timeout;
    private static final IoTPrinter ioTPrinter;
    private static final String BASE_VIEW_TYPE = "BASE";
    private static final String HEADER_VIEW_TYPE = "ViewType";
    private static final String HEADER_TIMESERIES = "Timeseries";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options options = ExportSchema.createOptions();
        HelpFormatter hf = new HelpFormatter();
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            ioTPrinter.println("Too few params input, please check the following hint.");
            hf.printHelp(EXPORT_SCHEMA_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            ioTPrinter.println(e.getMessage());
            hf.printHelp(EXPORT_SCHEMA_CLI_PREFIX, options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(EXPORT_SCHEMA_CLI_PREFIX, options, true);
            System.exit(1);
        }
        int exitCode = 0;
        try {
            ExportSchema.parseBasicParams(commandLine);
            ExportSchema.parseSpecialParams(commandLine);
            session = new Session(host, Integer.parseInt(port), username, password);
            session.open(false);
            if (queryPath == null) {
                String pathFile = commandLine.getOptionValue(TARGET_FILE_ARGS);
                if (pathFile == null) {
                    LineReader lineReader = JlineUtils.getLineReader(new CliContext(System.in, System.out, System.err, ExitType.EXCEPTION), username, host, port);
                    String path = lineReader.readLine("ExportSchema> please input path pattern: ");
                    ioTPrinter.println(path);
                    String[] values = path.trim().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        if (StringUtils.isBlank((CharSequence)values[i])) continue;
                        ExportSchema.dumpResult(values[i], i);
                    }
                } else if (!pathFile.endsWith(".txt")) {
                    ioTPrinter.println("The file name must end with \"txt\"!");
                    hf.printHelp(EXPORT_SCHEMA_CLI_PREFIX, options, true);
                    System.exit(1);
                } else {
                    ExportSchema.dumpFromPathFile(pathFile);
                }
            } else {
                ExportSchema.dumpResult(queryPath, 0);
            }
        }
        catch (IOException e) {
            ioTPrinter.println("Failed to operate on file, because " + e.getMessage());
            exitCode = 1;
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Invalid args: " + e.getMessage());
            exitCode = 1;
        }
        catch (IoTDBConnectionException e) {
            ioTPrinter.println("Connect failed because " + e.getMessage());
            exitCode = 1;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException e) {
                    exitCode = 1;
                    ioTPrinter.println("Encounter an error when closing session, error is: " + e.getMessage());
                }
            }
        }
        System.exit(exitCode);
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetDirectory = ExportSchema.checkRequiredArg(TARGET_DIR_ARGS, TARGET_DIR_ARGS_NAME, commandLine, null);
        queryPath = commandLine.getOptionValue(TARGET_PATH_ARGS);
        String timeoutString = commandLine.getOptionValue("timeout");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        if (targetFile == null) {
            targetFile = DUMP_FILE_NAME_DEFAULT;
        }
        if (!targetDirectory.endsWith("/") && !targetDirectory.endsWith("\\")) {
            targetDirectory = targetDirectory + File.separator;
        }
        if (commandLine.getOptionValue(LINES_PER_FILE_ARGS) != null) {
            linesPerFile = Integer.parseInt(commandLine.getOptionValue(LINES_PER_FILE_ARGS));
        }
    }

    private static Options createOptions() {
        Options options = ExportSchema.createNewOptions();
        Option opTargetFile = Option.builder((String)TARGET_DIR_ARGS).required().longOpt(TARGET_DIR_ARGS_NAME).hasArg().argName(TARGET_DIR_NAME).desc("Target File Directory (required)").build();
        options.addOption(opTargetFile);
        Option targetPathPattern = Option.builder((String)TARGET_PATH_ARGS).longOpt(TARGET_PATH_ARGS_NAME).hasArg().argName(TARGET_PATH_NAME).desc("Export Path Pattern (optional)").build();
        options.addOption(targetPathPattern);
        Option targetFileName = Option.builder((String)TARGET_FILE_ARGS).longOpt(TARGET_FILE_ARGS_NAME).hasArg().argName(TARGET_FILE_NAME).desc("Export File Name (optional)").build();
        options.addOption(targetFileName);
        Option opLinesPerFile = Option.builder((String)LINES_PER_FILE_ARGS).longOpt(LINES_PER_FILE_ARGS_NAME).hasArg().argName(LINES_PER_FILE_NAME).desc("Lines per dump file.").build();
        options.addOption(opLinesPerFile);
        Option opTimeout = Option.builder((String)"timeout").longOpt("queryTimeout").hasArg().argName("timeout").desc(timeout + " Timeout for session query").build();
        options.addOption(opTimeout);
        Option opHelp = Option.builder((String)"help").longOpt("help").desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    private static void dumpFromPathFile(String pathFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(pathFile));){
            String path;
            int index = 0;
            while ((path = reader.readLine()) != null) {
                ExportSchema.dumpResult(path, index);
                ++index;
            }
        }
    }

    private static void dumpResult(String pattern, int index) {
        File file = new File(targetDirectory);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        String path = targetDirectory + targetFile + index;
        try {
            SessionDataSet sessionDataSet = session.executeQueryStatement("show timeseries " + pattern, timeout);
            ExportSchema.writeCsvFile(sessionDataSet, path, sessionDataSet.getColumnNames(), linesPerFile);
            sessionDataSet.closeOperationHandle();
            ioTPrinter.println("Export completely!");
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Cannot dump result because: " + e.getMessage());
        }
    }

    public static void writeCsvFile(SessionDataSet sessionDataSet, String filePath, List<String> headers, int linesPerFile) throws IOException, IoTDBConnectionException, StatementExecutionException {
        int viewTypeIndex = headers.indexOf(HEADER_VIEW_TYPE);
        int timeseriesIndex = headers.indexOf(HEADER_TIMESERIES);
        int fileIndex = 0;
        boolean hasNext = true;
        while (hasNext) {
            int i = 0;
            String finalFilePath = filePath + "_" + fileIndex + ".csv";
            AbstractSchemaTool.CSVPrinterWrapper csvPrinterWrapper = new AbstractSchemaTool.CSVPrinterWrapper(finalFilePath);
            while (i++ < linesPerFile) {
                if (sessionDataSet.hasNext()) {
                    RowRecord rowRecord;
                    List fields;
                    if (i == 1) {
                        csvPrinterWrapper.printRecord(HEAD_COLUMNS);
                    }
                    if (((Field)(fields = (rowRecord = sessionDataSet.next()).getFields()).get(timeseriesIndex)).getStringValue().startsWith("root.__system.") || !((Field)fields.get(viewTypeIndex)).getStringValue().equals(BASE_VIEW_TYPE)) continue;
                    HEAD_COLUMNS.forEach(column -> {
                        Field field = (Field)fields.get(headers.indexOf(column));
                        String fieldStringValue = field.getStringValue();
                        if (!"null".equals(field.getStringValue())) {
                            csvPrinterWrapper.print(fieldStringValue);
                        } else {
                            csvPrinterWrapper.print("");
                        }
                    });
                    csvPrinterWrapper.println();
                    continue;
                }
                hasNext = false;
                break;
            }
            ++fileIndex;
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
        }
    }

    static {
        linesPerFile = 10000;
        targetFile = DUMP_FILE_NAME_DEFAULT;
        timeout = 60000L;
        ioTPrinter = new IoTPrinter(System.out);
    }
}

