/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.type.ExitType;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.iotdb.tool.tsfile.ExportTsFile;
import org.apache.thrift.TException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.utils.BytesUtils;
import org.jline.reader.LineReader;

public class ExportData
extends AbstractDataTool {
    private static final String TARGET_DIR_ARGS = "t";
    private static final String TARGET_DIR_NAME = "target";
    private static final String TARGET_DIR_ARGS_NAME = "target_directory";
    private static final String TARGET_FILE_ARGS = "pfn";
    private static final String TARGET_FILE_NAME = "prefix_file_name";
    private static final String SQL_FILE_ARGS = "s";
    private static final String SQL_FILE_NAME = "sourceSqlFile";
    private static final String DATA_TYPE_ARGS = "dt";
    private static final String DATA_TYPE_NAME = "datatype";
    private static final String QUERY_COMMAND_ARGS = "q";
    private static final String QUERY_COMMAND_NAME = "query";
    private static final String QUERY_COMMAND_ARGS_NAME = "query_command";
    private static final String EXPORT_SQL_TYPE_NAME = "sql";
    private static final String ALIGNED_ARGS = "aligned";
    private static final String ALIGNED_NAME = "export_aligned";
    private static final String ALIGNED_ARGS_NAME = "export aligned insert sql";
    private static final String LINES_PER_FILE_ARGS = "lpf";
    private static final String LINES_PER_FILE_NAME = "lines_per_file";
    private static final String TSFILEDB_CLI_PREFIX = "Export Data";
    private static final String DUMP_FILE_NAME_DEFAULT = "dump";
    private static String targetFile = "dump";
    private static Session session;
    private static String targetDirectory;
    private static Boolean needDataTypePrinted;
    private static String queryCommand;
    private static String timestampPrecision;
    private static int linesPerFile;
    private static long timeout;
    private static Boolean aligned;
    private static String fileType;
    private static final IoTPrinter ioTPrinter;
    private static final String TSFILEDB_CLI_HEAD = "Please obtain help information for the corresponding data type based on different parameters, for example:\n./export_data.sh -help tsfile\n./export_data.sh -help sql\n./export_data.sh -help csv";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options helpOptions = ExportData.createHelpOptions();
        Options tsFileOptions = ExportData.createTsFileOptions();
        Options csvOptions = ExportData.createCsvOptions();
        Options sqlOptions = ExportData.createSqlOptions();
        HelpFormatter hf = new HelpFormatter();
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        if (args == null || args.length == 0) {
            ExportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(helpOptions, args, true);
        }
        catch (ParseException e) {
            ExportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
            System.exit(1);
        }
        List<String> argList = Arrays.asList(args);
        int helpIndex = argList.indexOf("-help");
        int ftIndex = argList.indexOf("-ft");
        if (ftIndex < 0) {
            ftIndex = argList.indexOf("-file_type");
        }
        if (helpIndex >= 0) {
            fileType = argList.get(helpIndex + 1);
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                if ("tsfile".equalsIgnoreCase(fileType)) {
                    ExportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, null, null, false);
                } else if ("csv".equalsIgnoreCase(fileType)) {
                    ExportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, null, csvOptions, null, false);
                } else if (EXPORT_SQL_TYPE_NAME.equalsIgnoreCase(fileType)) {
                    ExportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, null, null, sqlOptions, false);
                } else {
                    ioTPrinter.println(String.format("File type %s is not support", fileType));
                    ExportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
                }
            } else {
                ExportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
            }
            System.exit(1);
        } else if (ftIndex >= 0) {
            fileType = argList.get(ftIndex + 1);
            if (StringUtils.isNotBlank((CharSequence)fileType)) {
                if ("tsfile".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(tsFileOptions, args, true);
                        ExportTsFile exportTsFile = new ExportTsFile(commandLine);
                        ExportTsFile.exportTsfile(0);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ExportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, null, null, false);
                        System.exit(1);
                    }
                } else if ("csv".equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(csvOptions, args, true);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ExportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, null, csvOptions, null, false);
                        System.exit(1);
                    }
                } else if (EXPORT_SQL_TYPE_NAME.equalsIgnoreCase(fileType)) {
                    try {
                        commandLine = parser.parse(sqlOptions, args, true);
                    }
                    catch (ParseException e) {
                        ioTPrinter.println("Parse error: " + e.getMessage());
                        ExportData.printHelpOptions(null, TSFILEDB_CLI_PREFIX, hf, null, null, sqlOptions, false);
                        System.exit(1);
                    }
                } else {
                    ioTPrinter.println(String.format("File type %s is not support", fileType));
                    ExportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
                    System.exit(1);
                }
            } else {
                ExportData.printHelpOptions(TSFILEDB_CLI_HEAD, TSFILEDB_CLI_PREFIX, hf, tsFileOptions, csvOptions, sqlOptions, true);
                System.exit(1);
            }
        } else {
            ioTPrinter.println(String.format("Invalid args: Required values for option '%s' not provided", "file_type"));
            System.exit(1);
        }
        int exitCode = 0;
        try {
            ExportData.parseBasicParams(commandLine);
            ExportData.parseSpecialParams(commandLine);
            if (!ExportData.checkTimeFormat()) {
                System.exit(1);
            }
            session = new Session(host, Integer.parseInt(port), username, password);
            session.open(false);
            timestampPrecision = session.getTimestampPrecision();
            ExportData.setTimeZone();
            if (queryCommand == null) {
                String sqlFile = commandLine.getOptionValue(SQL_FILE_ARGS);
                if (sqlFile == null) {
                    LineReader lineReader = JlineUtils.getLineReader(new CliContext(System.in, System.out, System.err, ExitType.EXCEPTION), username, host, port);
                    String sql = lineReader.readLine("Export Data> please input query: ");
                    ioTPrinter.println(sql);
                    String[] values = sql.trim().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        ExportData.dumpResult(values[i], i);
                    }
                } else {
                    ExportData.dumpFromSqlFile(sqlFile);
                }
            } else {
                ExportData.dumpResult(queryCommand, 0);
            }
        }
        catch (IOException e) {
            ioTPrinter.println("Failed to operate on file, because " + e.getMessage());
            exitCode = 1;
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Invalid args: " + e.getMessage());
            exitCode = 1;
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Connect failed because " + e.getMessage());
            exitCode = 1;
        }
        catch (TException e) {
            ioTPrinter.println("Can not get the timestamp precision from server because " + e.getMessage());
            exitCode = 1;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException e) {
                    exitCode = 1;
                    ioTPrinter.println("Encounter an error when closing session, error is: " + e.getMessage());
                }
            }
        }
        System.exit(exitCode);
    }

    private static Options createTsFileOptions() {
        Options options = ExportData.createExportOptions();
        Option opFile = Option.builder((String)TARGET_DIR_ARGS).required().longOpt(TARGET_DIR_NAME).argName(TARGET_DIR_ARGS_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opFile);
        Option opOnSuccess = Option.builder((String)TARGET_FILE_ARGS).longOpt(TARGET_FILE_NAME).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(opOnSuccess);
        Option opQuery = Option.builder((String)QUERY_COMMAND_ARGS).longOpt(QUERY_COMMAND_NAME).argName(QUERY_COMMAND_ARGS_NAME).hasArg().desc("The query command that you want to execute. (optional)").build();
        options.addOption(opQuery);
        Option opTimeOut = Option.builder((String)"timeout").longOpt("query_timeout").argName("query_timeout").hasArg().desc("Timeout for session query (optional)").build();
        options.addOption(opTimeOut);
        return options;
    }

    private static Options createCsvOptions() {
        Options options = ExportData.createExportOptions();
        Option opFile = Option.builder((String)TARGET_DIR_ARGS).required().longOpt(TARGET_DIR_NAME).argName(TARGET_DIR_ARGS_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opFile);
        Option opOnSuccess = Option.builder((String)TARGET_FILE_ARGS).longOpt(TARGET_FILE_NAME).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(opOnSuccess);
        Option opDataType = Option.builder((String)DATA_TYPE_ARGS).longOpt(DATA_TYPE_NAME).argName(DATA_TYPE_NAME).hasArg().desc("Will the data type of timeseries be printed in the head line of the CSV file?\nYou can choose true) or false) . (optional)").build();
        options.addOption(opDataType);
        Option opLinesPerFile = Option.builder((String)LINES_PER_FILE_ARGS).longOpt(LINES_PER_FILE_NAME).argName(LINES_PER_FILE_NAME).hasArg().desc("Lines per dump file.(optional)").build();
        options.addOption(opLinesPerFile);
        Option opTimeFormat = Option.builder((String)"tf").longOpt("time_format").argName("time_format").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd HH:mm:ss, default ISO8601.\n OutPut timestamp in sql file, No matter what time format is set(optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").longOpt("query_timeout").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opQuery = Option.builder((String)QUERY_COMMAND_ARGS).longOpt(QUERY_COMMAND_NAME).argName(QUERY_COMMAND_ARGS_NAME).hasArg().desc("The query command that you want to execute. (optional)").build();
        options.addOption(opQuery);
        Option opTimeOut = Option.builder((String)"timeout").longOpt("query_timeout").argName("query_timeout").hasArg().desc("Timeout for session query (optional)").build();
        options.addOption(opTimeOut);
        return options;
    }

    private static Options createSqlOptions() {
        Options options = ExportData.createExportOptions();
        Option opFile = Option.builder((String)TARGET_DIR_ARGS).required().longOpt(TARGET_DIR_NAME).argName(TARGET_DIR_ARGS_NAME).hasArg().desc("Target File Directory (required)").build();
        options.addOption(opFile);
        Option opOnSuccess = Option.builder((String)TARGET_FILE_ARGS).longOpt(TARGET_FILE_NAME).argName(TARGET_FILE_NAME).hasArg().desc("Export file name (optional)").build();
        options.addOption(opOnSuccess);
        Option opAligned = Option.builder((String)ALIGNED_ARGS).longOpt(ALIGNED_NAME).argName(ALIGNED_ARGS_NAME).hasArgs().desc("Whether export to sql of aligned (optional)").build();
        options.addOption(opAligned);
        Option opTimeFormat = Option.builder((String)"tf").longOpt("time_format").argName("time_format").hasArg().desc("Output time Format in csv file. You can choose 1) timestamp, number, long 2) ISO8601, default 3) user-defined pattern like yyyy-MM-dd HH:mm:ss, default ISO8601.\n OutPut timestamp in sql file, No matter what time format is set(optional)").build();
        options.addOption(opTimeFormat);
        Option opTimeZone = Option.builder((String)"tz").longOpt("timezone").argName("timezone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opLinesPerFile = Option.builder((String)LINES_PER_FILE_ARGS).longOpt(LINES_PER_FILE_NAME).argName(LINES_PER_FILE_NAME).hasArg().desc("Lines per dump file.(optional)").build();
        options.addOption(opLinesPerFile);
        Option opQuery = Option.builder((String)QUERY_COMMAND_ARGS).longOpt(QUERY_COMMAND_NAME).argName(QUERY_COMMAND_ARGS_NAME).hasArg().desc("The query command that you want to execute. (optional)").build();
        options.addOption(opQuery);
        Option opTimeOut = Option.builder((String)"timeout").longOpt("query_timeout").argName("query_timeout").hasArg().desc("Timeout for session query (optional)").build();
        options.addOption(opTimeOut);
        return options;
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        File file;
        targetDirectory = ExportData.checkRequiredArg(TARGET_DIR_ARGS, TARGET_DIR_NAME, commandLine, null);
        targetFile = commandLine.getOptionValue(TARGET_FILE_ARGS);
        needDataTypePrinted = Boolean.valueOf(commandLine.getOptionValue(DATA_TYPE_ARGS));
        queryCommand = commandLine.getOptionValue(QUERY_COMMAND_ARGS);
        exportType = commandLine.getOptionValue("ft");
        String timeoutString = commandLine.getOptionValue("timeout");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        if (needDataTypePrinted == null) {
            needDataTypePrinted = true;
        }
        if (targetFile == null) {
            targetFile = DUMP_FILE_NAME_DEFAULT;
        }
        if ((timeFormat = commandLine.getOptionValue("tf")) == null) {
            timeFormat = "default";
        }
        timeZoneID = commandLine.getOptionValue("tz");
        if (!targetDirectory.endsWith("/") && !targetDirectory.endsWith("\\")) {
            targetDirectory = targetDirectory + File.separator;
        }
        if (!(file = new File(targetDirectory)).isDirectory() && !file.mkdirs()) {
            ioTPrinter.println(String.format("Failed to create directories %s", targetDirectory));
            System.exit(1);
        }
        if (commandLine.getOptionValue(LINES_PER_FILE_ARGS) != null) {
            linesPerFile = Integer.parseInt(commandLine.getOptionValue(LINES_PER_FILE_ARGS));
        }
        if (commandLine.getOptionValue(ALIGNED_ARGS) != null) {
            aligned = Boolean.valueOf(commandLine.getOptionValue(ALIGNED_ARGS));
        }
    }

    protected static void setTimeZone() throws IoTDBConnectionException, StatementExecutionException {
        if (timeZoneID != null) {
            session.setTimeZone(timeZoneID);
        }
        zoneId = ZoneId.of(session.getTimeZone());
    }

    private static void dumpFromSqlFile(String filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String sql;
            int index = 0;
            while ((sql = reader.readLine()) != null) {
                ExportData.dumpResult(sql, index);
                ++index;
            }
        }
    }

    private static void dumpResult(String sql, int index) {
        if (EXPORT_SQL_TYPE_NAME.equalsIgnoreCase(exportType)) {
            ExportData.legalCheck(sql);
        }
        String path = targetDirectory + targetFile + index;
        try {
            SessionDataSet sessionDataSet = session.executeQueryStatement(sql, timeout);
            ArrayList<Object> headers = new ArrayList<Object>();
            List names = sessionDataSet.getColumnNames();
            List types = sessionDataSet.getColumnTypes();
            if (EXPORT_SQL_TYPE_NAME.equalsIgnoreCase(exportType)) {
                ExportData.writeSqlFile(sessionDataSet, path, names, linesPerFile);
            } else {
                if (Boolean.TRUE.equals(needDataTypePrinted)) {
                    for (int i = 0; i < names.size(); ++i) {
                        if (!"Time".equals(names.get(i)) && !"Device".equals(names.get(i))) {
                            headers.add(String.format("%s(%s)", names.get(i), types.get(i)));
                            continue;
                        }
                        headers.add(names.get(i));
                    }
                } else {
                    headers.addAll(names);
                }
                ExportData.writeCsvFile(sessionDataSet, path, headers, linesPerFile);
            }
            sessionDataSet.closeOperationHandle();
            ioTPrinter.println("Export completely!");
        }
        catch (IOException | IoTDBConnectionException | StatementExecutionException e) {
            ioTPrinter.println("Cannot dump result because: " + e.getMessage());
        }
    }

    private static void legalCheck(String sql) {
        String aggregatePattern = "\\b(count|sum|avg|extreme|max_value|min_value|first_value|last_value|max_time|min_time|stddev|stddev_pop|stddev_samp|variance|var_pop|var_samp|max_by|min_by)\\b\\s*\\(";
        Pattern pattern = Pattern.compile(aggregatePattern, 2);
        Matcher matcher = pattern.matcher(sql.toUpperCase(Locale.ROOT));
        if (matcher.find()) {
            ioTPrinter.println("The sql you entered is invalid, please don't use aggregate query.");
        }
    }

    public static String timeTrans(Long time) {
        switch (timeFormat) {
            case "default": {
                return RpcUtils.parseLongToDateWithPrecision((DateTimeFormatter)DateTimeFormatter.ISO_OFFSET_DATE_TIME, (long)time, (ZoneId)zoneId, (String)timestampPrecision);
            }
            case "timestamp": 
            case "long": 
            case "number": {
                return String.valueOf(time);
            }
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), zoneId).format(DateTimeFormatter.ofPattern(timeFormat));
    }

    public static void writeCsvFile(SessionDataSet sessionDataSet, String filePath, List<Object> headers, int linesPerFile) throws IOException, IoTDBConnectionException, StatementExecutionException {
        int fileIndex = 0;
        boolean hasNext = true;
        while (hasNext) {
            int i = 0;
            String finalFilePath = filePath + "_" + fileIndex + ".csv";
            AbstractDataTool.CSVPrinterWrapper csvPrinterWrapper = new AbstractDataTool.CSVPrinterWrapper(finalFilePath);
            csvPrinterWrapper.printRecord(headers);
            while (i++ < linesPerFile) {
                if (sessionDataSet.hasNext()) {
                    RowRecord rowRecord = sessionDataSet.next();
                    if ("Time".equals(headers.get(0))) {
                        csvPrinterWrapper.print(ExportData.timeTrans(rowRecord.getTimestamp()));
                    }
                    rowRecord.getFields().forEach(field -> {
                        String fieldStringValue = field.getStringValue();
                        if (!"null".equals(field.getStringValue())) {
                            TSDataType dataType = field.getDataType();
                            if (!(dataType != TSDataType.TEXT && dataType != TSDataType.STRING || fieldStringValue.startsWith("root."))) {
                                fieldStringValue = "\"" + fieldStringValue + "\"";
                            } else if (dataType == TSDataType.BLOB) {
                                byte[] v = field.getBinaryV().getValues();
                                fieldStringValue = v == null ? null : BytesUtils.parseBlobByteArrayToString((byte[])v);
                            } else if (dataType == TSDataType.DATE) {
                                LocalDate dateV = field.getDateV();
                                fieldStringValue = dateV == null ? null : dateV.toString();
                            }
                            csvPrinterWrapper.print(fieldStringValue);
                        } else {
                            csvPrinterWrapper.print("");
                        }
                    });
                    csvPrinterWrapper.println();
                    continue;
                }
                hasNext = false;
                break;
            }
            ++fileIndex;
            csvPrinterWrapper.flush();
            csvPrinterWrapper.close();
        }
    }

    public static void writeSqlFile(SessionDataSet sessionDataSet, String filePath, List<String> headers, int linesPerFile) throws IOException, IoTDBConnectionException, StatementExecutionException {
        int i;
        int fileIndex = 0;
        String deviceName = null;
        boolean writeNull = false;
        ArrayList<String> seriesList = new ArrayList<String>(headers);
        if (CollectionUtils.isEmpty(headers) || headers.size() <= 1) {
            writeNull = true;
        } else if (headers.contains("Device")) {
            seriesList.remove("Time");
            seriesList.remove("Device");
        } else {
            Path path = new Path((String)seriesList.get(1), true);
            deviceName = path.getDevice();
            seriesList.remove("Time");
            for (i = 0; i < seriesList.size(); ++i) {
                String series = (String)seriesList.get(i);
                path = new Path(series, true);
                seriesList.set(i, path.getMeasurement());
            }
        }
        boolean hasNext = true;
        while (hasNext) {
            i = 0;
            String finalFilePath = filePath + "_" + fileIndex + ".sql";
            try (FileWriter writer = new FileWriter(finalFilePath);){
                if (writeNull) break;
                while (i++ < linesPerFile) {
                    if (sessionDataSet.hasNext()) {
                        RowRecord rowRecord = sessionDataSet.next();
                        List fields = rowRecord.getFields();
                        ArrayList<String> headersTemp = new ArrayList<String>(seriesList);
                        ArrayList<String> timeseries = new ArrayList<String>();
                        if (headers.contains("Device")) {
                            deviceName = ((Field)fields.get(0)).toString();
                            if (deviceName.startsWith("root.__system.")) continue;
                            for (String header : headersTemp) {
                                timeseries.add(deviceName + "." + header);
                            }
                        } else {
                            if (headers.get(1).startsWith("root.__system.")) continue;
                            timeseries.addAll(headers);
                            timeseries.remove(0);
                        }
                        String sqlMiddle = null;
                        sqlMiddle = Boolean.TRUE.equals(aligned) ? " ALIGNED VALUES (" + rowRecord.getTimestamp() + "," : " VALUES (" + rowRecord.getTimestamp() + ",";
                        ArrayList<String> values = new ArrayList<String>();
                        if (headers.contains("Device")) {
                            fields.remove(0);
                        }
                        for (int index = 0; index < fields.size(); ++index) {
                            RowRecord next = session.executeQueryStatement("SHOW TIMESERIES " + (String)timeseries.get(index), timeout).next();
                            if (ObjectUtils.isNotEmpty((Object)next)) {
                                List timeseriesList = next.getFields();
                                String value = ((Field)fields.get(index)).toString();
                                if (value.equals("null")) {
                                    headersTemp.remove(seriesList.get(index));
                                    continue;
                                }
                                String dataType = ((Field)timeseriesList.get(3)).getStringValue();
                                if (TSDataType.TEXT.name().equalsIgnoreCase(dataType) || TSDataType.STRING.name().equalsIgnoreCase(dataType)) {
                                    values.add("'" + value + "'");
                                    continue;
                                }
                                if (TSDataType.BLOB.name().equalsIgnoreCase(dataType)) {
                                    byte[] v = ((Field)fields.get(index)).getBinaryV().getValues();
                                    if (v == null) {
                                        values.add(null);
                                        continue;
                                    }
                                    values.add(BytesUtils.parseBlobByteArrayToString((byte[])v).replaceFirst("0x", "X'") + "'");
                                    continue;
                                }
                                if (TSDataType.DATE.name().equalsIgnoreCase(dataType)) {
                                    LocalDate dateV = ((Field)fields.get(index)).getDateV();
                                    if (dateV == null) {
                                        values.add(null);
                                        continue;
                                    }
                                    values.add("'" + dateV.toString() + "'");
                                    continue;
                                }
                                values.add(value);
                                continue;
                            }
                            headersTemp.remove(seriesList.get(index));
                        }
                        if (!CollectionUtils.isNotEmpty(headersTemp)) continue;
                        writer.write("INSERT INTO " + deviceName + "(TIMESTAMP," + String.join((CharSequence)",", headersTemp) + ")" + sqlMiddle + String.join((CharSequence)",", values) + ");\n");
                        continue;
                    }
                    hasNext = false;
                    break;
                }
                ++fileIndex;
                writer.flush();
            }
        }
    }

    static {
        linesPerFile = 10000;
        timeout = -1L;
        aligned = false;
        fileType = null;
        ioTPrinter = new IoTPrinter(System.out);
    }
}

