/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SetTriggeringRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=773");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=775");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=774");
    private final RequestHeader requestHeader;
    private final UInteger subscriptionId;
    private final UInteger triggeringItemId;
    private final UInteger[] linksToAdd;
    private final UInteger[] linksToRemove;

    public SetTriggeringRequest(RequestHeader requestHeader, UInteger subscriptionId, UInteger triggeringItemId, UInteger[] linksToAdd, UInteger[] linksToRemove) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.triggeringItemId = triggeringItemId;
        this.linksToAdd = linksToAdd;
        this.linksToRemove = linksToRemove;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public UInteger getTriggeringItemId() {
        return this.triggeringItemId;
    }

    public UInteger[] getLinksToAdd() {
        return this.linksToAdd;
    }

    public UInteger[] getLinksToRemove() {
        return this.linksToRemove;
    }

    protected SetTriggeringRequest(SetTriggeringRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((SetTriggeringRequestBuilder)b).requestHeader;
        this.subscriptionId = ((SetTriggeringRequestBuilder)b).subscriptionId;
        this.triggeringItemId = ((SetTriggeringRequestBuilder)b).triggeringItemId;
        this.linksToAdd = ((SetTriggeringRequestBuilder)b).linksToAdd;
        this.linksToRemove = ((SetTriggeringRequestBuilder)b).linksToRemove;
    }

    public static SetTriggeringRequestBuilder<?, ?> builder() {
        return new SetTriggeringRequestBuilderImpl();
    }

    public SetTriggeringRequestBuilder<?, ?> toBuilder() {
        return new SetTriggeringRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetTriggeringRequest)) {
            return false;
        }
        SetTriggeringRequest other = (SetTriggeringRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        UInteger this$triggeringItemId = this.getTriggeringItemId();
        UInteger other$triggeringItemId = other.getTriggeringItemId();
        if (this$triggeringItemId == null ? other$triggeringItemId != null : !((Object)this$triggeringItemId).equals(other$triggeringItemId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLinksToAdd(), other.getLinksToAdd())) {
            return false;
        }
        return Arrays.deepEquals(this.getLinksToRemove(), other.getLinksToRemove());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetTriggeringRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        UInteger $triggeringItemId = this.getTriggeringItemId();
        result = result * 59 + ($triggeringItemId == null ? 43 : ((Object)$triggeringItemId).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLinksToAdd());
        result = result * 59 + Arrays.deepHashCode(this.getLinksToRemove());
        return result;
    }

    @Override
    public String toString() {
        return "SetTriggeringRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", triggeringItemId=" + this.getTriggeringItemId() + ", linksToAdd=" + Arrays.deepToString(this.getLinksToAdd()) + ", linksToRemove=" + Arrays.deepToString(this.getLinksToRemove()) + ")";
    }

    private static final class SetTriggeringRequestBuilderImpl
    extends SetTriggeringRequestBuilder<SetTriggeringRequest, SetTriggeringRequestBuilderImpl> {
        private SetTriggeringRequestBuilderImpl() {
        }

        @Override
        protected SetTriggeringRequestBuilderImpl self() {
            return this;
        }

        @Override
        public SetTriggeringRequest build() {
            return new SetTriggeringRequest(this);
        }
    }

    public static abstract class SetTriggeringRequestBuilder<C extends SetTriggeringRequest, B extends SetTriggeringRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger subscriptionId;
        private UInteger triggeringItemId;
        private UInteger[] linksToAdd;
        private UInteger[] linksToRemove;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SetTriggeringRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SetTriggeringRequest instance, SetTriggeringRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionId(instance.subscriptionId);
            b.triggeringItemId(instance.triggeringItemId);
            b.linksToAdd(instance.linksToAdd);
            b.linksToRemove(instance.linksToRemove);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B triggeringItemId(UInteger triggeringItemId) {
            this.triggeringItemId = triggeringItemId;
            return (B)this.self();
        }

        public B linksToAdd(UInteger[] linksToAdd) {
            this.linksToAdd = linksToAdd;
            return (B)this.self();
        }

        public B linksToRemove(UInteger[] linksToRemove) {
            this.linksToRemove = linksToRemove;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SetTriggeringRequest.SetTriggeringRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionId=" + this.subscriptionId + ", triggeringItemId=" + this.triggeringItemId + ", linksToAdd=" + Arrays.deepToString(this.linksToAdd) + ", linksToRemove=" + Arrays.deepToString(this.linksToRemove) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SetTriggeringRequest> {
        @Override
        public Class<SetTriggeringRequest> getType() {
            return SetTriggeringRequest.class;
        }

        @Override
        public SetTriggeringRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            UInteger triggeringItemId = decoder.readUInt32("TriggeringItemId");
            UInteger[] linksToAdd = decoder.readUInt32Array("LinksToAdd");
            UInteger[] linksToRemove = decoder.readUInt32Array("LinksToRemove");
            return new SetTriggeringRequest(requestHeader, subscriptionId, triggeringItemId, linksToAdd, linksToRemove);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SetTriggeringRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeUInt32("TriggeringItemId", value.getTriggeringItemId());
            encoder.writeUInt32Array("LinksToAdd", value.getLinksToAdd());
            encoder.writeUInt32Array("LinksToRemove", value.getLinksToRemove());
        }
    }
}

