/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadRawModifiedDetails
extends HistoryReadDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=647");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=649");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=648");
    private final Boolean isReadModified;
    private final DateTime startTime;
    private final DateTime endTime;
    private final UInteger numValuesPerNode;
    private final Boolean returnBounds;

    public ReadRawModifiedDetails(Boolean isReadModified, DateTime startTime, DateTime endTime, UInteger numValuesPerNode, Boolean returnBounds) {
        this.isReadModified = isReadModified;
        this.startTime = startTime;
        this.endTime = endTime;
        this.numValuesPerNode = numValuesPerNode;
        this.returnBounds = returnBounds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getIsReadModified() {
        return this.isReadModified;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public UInteger getNumValuesPerNode() {
        return this.numValuesPerNode;
    }

    public Boolean getReturnBounds() {
        return this.returnBounds;
    }

    protected ReadRawModifiedDetails(ReadRawModifiedDetailsBuilder<?, ?> b) {
        super((HistoryReadDetails.HistoryReadDetailsBuilder<?, ?>)b);
        this.isReadModified = ((ReadRawModifiedDetailsBuilder)b).isReadModified;
        this.startTime = ((ReadRawModifiedDetailsBuilder)b).startTime;
        this.endTime = ((ReadRawModifiedDetailsBuilder)b).endTime;
        this.numValuesPerNode = ((ReadRawModifiedDetailsBuilder)b).numValuesPerNode;
        this.returnBounds = ((ReadRawModifiedDetailsBuilder)b).returnBounds;
    }

    public static ReadRawModifiedDetailsBuilder<?, ?> builder() {
        return new ReadRawModifiedDetailsBuilderImpl();
    }

    public ReadRawModifiedDetailsBuilder<?, ?> toBuilder() {
        return new ReadRawModifiedDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadRawModifiedDetails)) {
            return false;
        }
        ReadRawModifiedDetails other = (ReadRawModifiedDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isReadModified = this.getIsReadModified();
        Boolean other$isReadModified = other.getIsReadModified();
        if (this$isReadModified == null ? other$isReadModified != null : !((Object)this$isReadModified).equals(other$isReadModified)) {
            return false;
        }
        Boolean this$returnBounds = this.getReturnBounds();
        Boolean other$returnBounds = other.getReturnBounds();
        if (this$returnBounds == null ? other$returnBounds != null : !((Object)this$returnBounds).equals(other$returnBounds)) {
            return false;
        }
        DateTime this$startTime = this.getStartTime();
        DateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        DateTime this$endTime = this.getEndTime();
        DateTime other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        UInteger this$numValuesPerNode = this.getNumValuesPerNode();
        UInteger other$numValuesPerNode = other.getNumValuesPerNode();
        return !(this$numValuesPerNode == null ? other$numValuesPerNode != null : !((Object)this$numValuesPerNode).equals(other$numValuesPerNode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReadRawModifiedDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isReadModified = this.getIsReadModified();
        result = result * 59 + ($isReadModified == null ? 43 : ((Object)$isReadModified).hashCode());
        Boolean $returnBounds = this.getReturnBounds();
        result = result * 59 + ($returnBounds == null ? 43 : ((Object)$returnBounds).hashCode());
        DateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        DateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        UInteger $numValuesPerNode = this.getNumValuesPerNode();
        result = result * 59 + ($numValuesPerNode == null ? 43 : ((Object)$numValuesPerNode).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReadRawModifiedDetails(isReadModified=" + this.getIsReadModified() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", numValuesPerNode=" + this.getNumValuesPerNode() + ", returnBounds=" + this.getReturnBounds() + ")";
    }

    private static final class ReadRawModifiedDetailsBuilderImpl
    extends ReadRawModifiedDetailsBuilder<ReadRawModifiedDetails, ReadRawModifiedDetailsBuilderImpl> {
        private ReadRawModifiedDetailsBuilderImpl() {
        }

        @Override
        protected ReadRawModifiedDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public ReadRawModifiedDetails build() {
            return new ReadRawModifiedDetails(this);
        }
    }

    public static abstract class ReadRawModifiedDetailsBuilder<C extends ReadRawModifiedDetails, B extends ReadRawModifiedDetailsBuilder<C, B>>
    extends HistoryReadDetails.HistoryReadDetailsBuilder<C, B> {
        private Boolean isReadModified;
        private DateTime startTime;
        private DateTime endTime;
        private UInteger numValuesPerNode;
        private Boolean returnBounds;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ReadRawModifiedDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ReadRawModifiedDetails instance, ReadRawModifiedDetailsBuilder<?, ?> b) {
            b.isReadModified(instance.isReadModified);
            b.startTime(instance.startTime);
            b.endTime(instance.endTime);
            b.numValuesPerNode(instance.numValuesPerNode);
            b.returnBounds(instance.returnBounds);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B isReadModified(Boolean isReadModified) {
            this.isReadModified = isReadModified;
            return (B)this.self();
        }

        public B startTime(DateTime startTime) {
            this.startTime = startTime;
            return (B)this.self();
        }

        public B endTime(DateTime endTime) {
            this.endTime = endTime;
            return (B)this.self();
        }

        public B numValuesPerNode(UInteger numValuesPerNode) {
            this.numValuesPerNode = numValuesPerNode;
            return (B)this.self();
        }

        public B returnBounds(Boolean returnBounds) {
            this.returnBounds = returnBounds;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ReadRawModifiedDetails.ReadRawModifiedDetailsBuilder(super=" + super.toString() + ", isReadModified=" + this.isReadModified + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", numValuesPerNode=" + this.numValuesPerNode + ", returnBounds=" + this.returnBounds + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReadRawModifiedDetails> {
        @Override
        public Class<ReadRawModifiedDetails> getType() {
            return ReadRawModifiedDetails.class;
        }

        @Override
        public ReadRawModifiedDetails decode(SerializationContext context, UaDecoder decoder) {
            Boolean isReadModified = decoder.readBoolean("IsReadModified");
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime endTime = decoder.readDateTime("EndTime");
            UInteger numValuesPerNode = decoder.readUInt32("NumValuesPerNode");
            Boolean returnBounds = decoder.readBoolean("ReturnBounds");
            return new ReadRawModifiedDetails(isReadModified, startTime, endTime, numValuesPerNode, returnBounds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReadRawModifiedDetails value) {
            encoder.writeBoolean("IsReadModified", value.getIsReadModified());
            encoder.writeDateTime("StartTime", value.getStartTime());
            encoder.writeDateTime("EndTime", value.getEndTime());
            encoder.writeUInt32("NumValuesPerNode", value.getNumValuesPerNode());
            encoder.writeBoolean("ReturnBounds", value.getReturnBounds());
        }
    }
}

