/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryDataSet;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class QueryNextResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=622");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=624");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=623");
    private final ResponseHeader responseHeader;
    private final QueryDataSet[] queryDataSets;
    private final ByteString revisedContinuationPoint;

    public QueryNextResponse(ResponseHeader responseHeader, QueryDataSet[] queryDataSets, ByteString revisedContinuationPoint) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSets;
        this.revisedContinuationPoint = revisedContinuationPoint;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public QueryDataSet[] getQueryDataSets() {
        return this.queryDataSets;
    }

    public ByteString getRevisedContinuationPoint() {
        return this.revisedContinuationPoint;
    }

    protected QueryNextResponse(QueryNextResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((QueryNextResponseBuilder)b).responseHeader;
        this.queryDataSets = ((QueryNextResponseBuilder)b).queryDataSets;
        this.revisedContinuationPoint = ((QueryNextResponseBuilder)b).revisedContinuationPoint;
    }

    public static QueryNextResponseBuilder<?, ?> builder() {
        return new QueryNextResponseBuilderImpl();
    }

    public QueryNextResponseBuilder<?, ?> toBuilder() {
        return new QueryNextResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryNextResponse)) {
            return false;
        }
        QueryNextResponse other = (QueryNextResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getQueryDataSets(), other.getQueryDataSets())) {
            return false;
        }
        ByteString this$revisedContinuationPoint = this.getRevisedContinuationPoint();
        ByteString other$revisedContinuationPoint = other.getRevisedContinuationPoint();
        return !(this$revisedContinuationPoint == null ? other$revisedContinuationPoint != null : !((Object)this$revisedContinuationPoint).equals(other$revisedContinuationPoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryNextResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getQueryDataSets());
        ByteString $revisedContinuationPoint = this.getRevisedContinuationPoint();
        result = result * 59 + ($revisedContinuationPoint == null ? 43 : ((Object)$revisedContinuationPoint).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QueryNextResponse(responseHeader=" + this.getResponseHeader() + ", queryDataSets=" + Arrays.deepToString(this.getQueryDataSets()) + ", revisedContinuationPoint=" + this.getRevisedContinuationPoint() + ")";
    }

    private static final class QueryNextResponseBuilderImpl
    extends QueryNextResponseBuilder<QueryNextResponse, QueryNextResponseBuilderImpl> {
        private QueryNextResponseBuilderImpl() {
        }

        @Override
        protected QueryNextResponseBuilderImpl self() {
            return this;
        }

        @Override
        public QueryNextResponse build() {
            return new QueryNextResponse(this);
        }
    }

    public static abstract class QueryNextResponseBuilder<C extends QueryNextResponse, B extends QueryNextResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private QueryDataSet[] queryDataSets;
        private ByteString revisedContinuationPoint;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QueryNextResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(QueryNextResponse instance, QueryNextResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.queryDataSets(instance.queryDataSets);
            b.revisedContinuationPoint(instance.revisedContinuationPoint);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B queryDataSets(QueryDataSet[] queryDataSets) {
            this.queryDataSets = queryDataSets;
            return (B)this.self();
        }

        public B revisedContinuationPoint(ByteString revisedContinuationPoint) {
            this.revisedContinuationPoint = revisedContinuationPoint;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "QueryNextResponse.QueryNextResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", queryDataSets=" + Arrays.deepToString(this.queryDataSets) + ", revisedContinuationPoint=" + this.revisedContinuationPoint + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryNextResponse> {
        @Override
        public Class<QueryNextResponse> getType() {
            return QueryNextResponse.class;
        }

        @Override
        public QueryNextResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            QueryDataSet[] queryDataSets = (QueryDataSet[])decoder.readStructArray("QueryDataSets", QueryDataSet.TYPE_ID);
            ByteString revisedContinuationPoint = decoder.readByteString("RevisedContinuationPoint");
            return new QueryNextResponse(responseHeader, queryDataSets, revisedContinuationPoint);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryNextResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("QueryDataSets", (Object[])value.getQueryDataSets(), QueryDataSet.TYPE_ID);
            encoder.writeByteString("RevisedContinuationPoint", value.getRevisedContinuationPoint());
        }
    }
}

