/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeAttributes;

public class ObjectAttributes
extends NodeAttributes
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=352");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=354");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=353");
    private final UByte eventNotifier;

    public ObjectAttributes(UInteger specifiedAttributes, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(specifiedAttributes, displayName, description, writeMask, userWriteMask);
        this.eventNotifier = eventNotifier;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UByte getEventNotifier() {
        return this.eventNotifier;
    }

    protected ObjectAttributes(ObjectAttributesBuilder<?, ?> b) {
        super((NodeAttributes.NodeAttributesBuilder<?, ?>)b);
        this.eventNotifier = ((ObjectAttributesBuilder)b).eventNotifier;
    }

    public static ObjectAttributesBuilder<?, ?> builder() {
        return new ObjectAttributesBuilderImpl();
    }

    public ObjectAttributesBuilder<?, ?> toBuilder() {
        return new ObjectAttributesBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectAttributes)) {
            return false;
        }
        ObjectAttributes other = (ObjectAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UByte this$eventNotifier = this.getEventNotifier();
        UByte other$eventNotifier = other.getEventNotifier();
        return !(this$eventNotifier == null ? other$eventNotifier != null : !((Object)this$eventNotifier).equals(other$eventNotifier));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectAttributes;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UByte $eventNotifier = this.getEventNotifier();
        result = result * 59 + ($eventNotifier == null ? 43 : ((Object)$eventNotifier).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ObjectAttributes(eventNotifier=" + this.getEventNotifier() + ")";
    }

    private static final class ObjectAttributesBuilderImpl
    extends ObjectAttributesBuilder<ObjectAttributes, ObjectAttributesBuilderImpl> {
        private ObjectAttributesBuilderImpl() {
        }

        @Override
        protected ObjectAttributesBuilderImpl self() {
            return this;
        }

        @Override
        public ObjectAttributes build() {
            return new ObjectAttributes(this);
        }
    }

    public static abstract class ObjectAttributesBuilder<C extends ObjectAttributes, B extends ObjectAttributesBuilder<C, B>>
    extends NodeAttributes.NodeAttributesBuilder<C, B> {
        private UByte eventNotifier;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ObjectAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ObjectAttributes instance, ObjectAttributesBuilder<?, ?> b) {
            b.eventNotifier(instance.eventNotifier);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B eventNotifier(UByte eventNotifier) {
            this.eventNotifier = eventNotifier;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ObjectAttributes.ObjectAttributesBuilder(super=" + super.toString() + ", eventNotifier=" + this.eventNotifier + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ObjectAttributes> {
        @Override
        public Class<ObjectAttributes> getType() {
            return ObjectAttributes.class;
        }

        @Override
        public ObjectAttributes decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedAttributes = decoder.readUInt32("SpecifiedAttributes");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            UByte eventNotifier = decoder.readByte("EventNotifier");
            return new ObjectAttributes(specifiedAttributes, displayName, description, writeMask, userWriteMask, eventNotifier);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ObjectAttributes value) {
            encoder.writeUInt32("SpecifiedAttributes", value.getSpecifiedAttributes());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeByte("EventNotifier", value.getEventNotifier());
        }
    }
}

