/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class Node
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=258");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=260");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=259");
    private final NodeId nodeId;
    private final NodeClass nodeClass;
    private final QualifiedName browseName;
    private final LocalizedText displayName;
    private final LocalizedText description;
    private final UInteger writeMask;
    private final UInteger userWriteMask;
    private final ReferenceNode[] references;

    public Node(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references) {
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
        this.references = references;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public NodeClass getNodeClass() {
        return this.nodeClass;
    }

    public QualifiedName getBrowseName() {
        return this.browseName;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public UInteger getWriteMask() {
        return this.writeMask;
    }

    public UInteger getUserWriteMask() {
        return this.userWriteMask;
    }

    public ReferenceNode[] getReferences() {
        return this.references;
    }

    protected Node(NodeBuilder<?, ?> b) {
        super(b);
        this.nodeId = ((NodeBuilder)b).nodeId;
        this.nodeClass = ((NodeBuilder)b).nodeClass;
        this.browseName = ((NodeBuilder)b).browseName;
        this.displayName = ((NodeBuilder)b).displayName;
        this.description = ((NodeBuilder)b).description;
        this.writeMask = ((NodeBuilder)b).writeMask;
        this.userWriteMask = ((NodeBuilder)b).userWriteMask;
        this.references = ((NodeBuilder)b).references;
    }

    public static NodeBuilder<?, ?> builder() {
        return new NodeBuilderImpl();
    }

    public NodeBuilder<?, ?> toBuilder() {
        return new NodeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$nodeId = this.getNodeId();
        NodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        NodeClass this$nodeClass = this.getNodeClass();
        NodeClass other$nodeClass = other.getNodeClass();
        if (this$nodeClass == null ? other$nodeClass != null : !this$nodeClass.equals(other$nodeClass)) {
            return false;
        }
        QualifiedName this$browseName = this.getBrowseName();
        QualifiedName other$browseName = other.getBrowseName();
        if (this$browseName == null ? other$browseName != null : !((Object)this$browseName).equals(other$browseName)) {
            return false;
        }
        LocalizedText this$displayName = this.getDisplayName();
        LocalizedText other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !((Object)this$displayName).equals(other$displayName)) {
            return false;
        }
        LocalizedText this$description = this.getDescription();
        LocalizedText other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        UInteger this$writeMask = this.getWriteMask();
        UInteger other$writeMask = other.getWriteMask();
        if (this$writeMask == null ? other$writeMask != null : !((Object)this$writeMask).equals(other$writeMask)) {
            return false;
        }
        UInteger this$userWriteMask = this.getUserWriteMask();
        UInteger other$userWriteMask = other.getUserWriteMask();
        if (this$userWriteMask == null ? other$userWriteMask != null : !((Object)this$userWriteMask).equals(other$userWriteMask)) {
            return false;
        }
        return Arrays.deepEquals(this.getReferences(), other.getReferences());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Node;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        NodeClass $nodeClass = this.getNodeClass();
        result = result * 59 + ($nodeClass == null ? 43 : $nodeClass.hashCode());
        QualifiedName $browseName = this.getBrowseName();
        result = result * 59 + ($browseName == null ? 43 : ((Object)$browseName).hashCode());
        LocalizedText $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : ((Object)$displayName).hashCode());
        LocalizedText $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        UInteger $writeMask = this.getWriteMask();
        result = result * 59 + ($writeMask == null ? 43 : ((Object)$writeMask).hashCode());
        UInteger $userWriteMask = this.getUserWriteMask();
        result = result * 59 + ($userWriteMask == null ? 43 : ((Object)$userWriteMask).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReferences());
        return result;
    }

    @Override
    public String toString() {
        return "Node(nodeId=" + this.getNodeId() + ", nodeClass=" + this.getNodeClass() + ", browseName=" + this.getBrowseName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", writeMask=" + this.getWriteMask() + ", userWriteMask=" + this.getUserWriteMask() + ", references=" + Arrays.deepToString(this.getReferences()) + ")";
    }

    private static final class NodeBuilderImpl
    extends NodeBuilder<Node, NodeBuilderImpl> {
        private NodeBuilderImpl() {
        }

        @Override
        protected NodeBuilderImpl self() {
            return this;
        }

        @Override
        public Node build() {
            return new Node(this);
        }
    }

    public static abstract class NodeBuilder<C extends Node, B extends NodeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId nodeId;
        private NodeClass nodeClass;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private LocalizedText description;
        private UInteger writeMask;
        private UInteger userWriteMask;
        private ReferenceNode[] references;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            NodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(Node instance, NodeBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.nodeClass(instance.nodeClass);
            b.browseName(instance.browseName);
            b.displayName(instance.displayName);
            b.description(instance.description);
            b.writeMask(instance.writeMask);
            b.userWriteMask(instance.userWriteMask);
            b.references(instance.references);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B nodeClass(NodeClass nodeClass) {
            this.nodeClass = nodeClass;
            return (B)this.self();
        }

        public B browseName(QualifiedName browseName) {
            this.browseName = browseName;
            return (B)this.self();
        }

        public B displayName(LocalizedText displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        public B description(LocalizedText description) {
            this.description = description;
            return (B)this.self();
        }

        public B writeMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return (B)this.self();
        }

        public B userWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return (B)this.self();
        }

        public B references(ReferenceNode[] references) {
            this.references = references;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Node.NodeBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", nodeClass=" + this.nodeClass + ", browseName=" + this.browseName + ", displayName=" + this.displayName + ", description=" + this.description + ", writeMask=" + this.writeMask + ", userWriteMask=" + this.userWriteMask + ", references=" + Arrays.deepToString(this.references) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<Node> {
        @Override
        public Class<Node> getType() {
            return Node.class;
        }

        @Override
        public Node decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readStructArray("References", ReferenceNode.TYPE_ID);
            return new Node(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, Node value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeStructArray("References", (Object[])value.getReferences(), ReferenceNode.TYPE_ID);
        }
    }
}

