/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class MonitoringParameters
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=740");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=742");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=741");
    private final UInteger clientHandle;
    private final Double samplingInterval;
    private final ExtensionObject filter;
    private final UInteger queueSize;
    private final Boolean discardOldest;

    public MonitoringParameters(UInteger clientHandle, Double samplingInterval, ExtensionObject filter, UInteger queueSize, Boolean discardOldest) {
        this.clientHandle = clientHandle;
        this.samplingInterval = samplingInterval;
        this.filter = filter;
        this.queueSize = queueSize;
        this.discardOldest = discardOldest;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getClientHandle() {
        return this.clientHandle;
    }

    public Double getSamplingInterval() {
        return this.samplingInterval;
    }

    public ExtensionObject getFilter() {
        return this.filter;
    }

    public UInteger getQueueSize() {
        return this.queueSize;
    }

    public Boolean getDiscardOldest() {
        return this.discardOldest;
    }

    protected MonitoringParameters(MonitoringParametersBuilder<?, ?> b) {
        super(b);
        this.clientHandle = ((MonitoringParametersBuilder)b).clientHandle;
        this.samplingInterval = ((MonitoringParametersBuilder)b).samplingInterval;
        this.filter = ((MonitoringParametersBuilder)b).filter;
        this.queueSize = ((MonitoringParametersBuilder)b).queueSize;
        this.discardOldest = ((MonitoringParametersBuilder)b).discardOldest;
    }

    public static MonitoringParametersBuilder<?, ?> builder() {
        return new MonitoringParametersBuilderImpl();
    }

    public MonitoringParametersBuilder<?, ?> toBuilder() {
        return new MonitoringParametersBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoringParameters)) {
            return false;
        }
        MonitoringParameters other = (MonitoringParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$samplingInterval = this.getSamplingInterval();
        Double other$samplingInterval = other.getSamplingInterval();
        if (this$samplingInterval == null ? other$samplingInterval != null : !((Object)this$samplingInterval).equals(other$samplingInterval)) {
            return false;
        }
        Boolean this$discardOldest = this.getDiscardOldest();
        Boolean other$discardOldest = other.getDiscardOldest();
        if (this$discardOldest == null ? other$discardOldest != null : !((Object)this$discardOldest).equals(other$discardOldest)) {
            return false;
        }
        UInteger this$clientHandle = this.getClientHandle();
        UInteger other$clientHandle = other.getClientHandle();
        if (this$clientHandle == null ? other$clientHandle != null : !((Object)this$clientHandle).equals(other$clientHandle)) {
            return false;
        }
        ExtensionObject this$filter = this.getFilter();
        ExtensionObject other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
            return false;
        }
        UInteger this$queueSize = this.getQueueSize();
        UInteger other$queueSize = other.getQueueSize();
        return !(this$queueSize == null ? other$queueSize != null : !((Object)this$queueSize).equals(other$queueSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitoringParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $samplingInterval = this.getSamplingInterval();
        result = result * 59 + ($samplingInterval == null ? 43 : ((Object)$samplingInterval).hashCode());
        Boolean $discardOldest = this.getDiscardOldest();
        result = result * 59 + ($discardOldest == null ? 43 : ((Object)$discardOldest).hashCode());
        UInteger $clientHandle = this.getClientHandle();
        result = result * 59 + ($clientHandle == null ? 43 : ((Object)$clientHandle).hashCode());
        ExtensionObject $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
        UInteger $queueSize = this.getQueueSize();
        result = result * 59 + ($queueSize == null ? 43 : ((Object)$queueSize).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MonitoringParameters(clientHandle=" + this.getClientHandle() + ", samplingInterval=" + this.getSamplingInterval() + ", filter=" + this.getFilter() + ", queueSize=" + this.getQueueSize() + ", discardOldest=" + this.getDiscardOldest() + ")";
    }

    private static final class MonitoringParametersBuilderImpl
    extends MonitoringParametersBuilder<MonitoringParameters, MonitoringParametersBuilderImpl> {
        private MonitoringParametersBuilderImpl() {
        }

        @Override
        protected MonitoringParametersBuilderImpl self() {
            return this;
        }

        @Override
        public MonitoringParameters build() {
            return new MonitoringParameters(this);
        }
    }

    public static abstract class MonitoringParametersBuilder<C extends MonitoringParameters, B extends MonitoringParametersBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger clientHandle;
        private Double samplingInterval;
        private ExtensionObject filter;
        private UInteger queueSize;
        private Boolean discardOldest;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MonitoringParametersBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MonitoringParameters instance, MonitoringParametersBuilder<?, ?> b) {
            b.clientHandle(instance.clientHandle);
            b.samplingInterval(instance.samplingInterval);
            b.filter(instance.filter);
            b.queueSize(instance.queueSize);
            b.discardOldest(instance.discardOldest);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B clientHandle(UInteger clientHandle) {
            this.clientHandle = clientHandle;
            return (B)this.self();
        }

        public B samplingInterval(Double samplingInterval) {
            this.samplingInterval = samplingInterval;
            return (B)this.self();
        }

        public B filter(ExtensionObject filter) {
            this.filter = filter;
            return (B)this.self();
        }

        public B queueSize(UInteger queueSize) {
            this.queueSize = queueSize;
            return (B)this.self();
        }

        public B discardOldest(Boolean discardOldest) {
            this.discardOldest = discardOldest;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MonitoringParameters.MonitoringParametersBuilder(super=" + super.toString() + ", clientHandle=" + this.clientHandle + ", samplingInterval=" + this.samplingInterval + ", filter=" + this.filter + ", queueSize=" + this.queueSize + ", discardOldest=" + this.discardOldest + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MonitoringParameters> {
        @Override
        public Class<MonitoringParameters> getType() {
            return MonitoringParameters.class;
        }

        @Override
        public MonitoringParameters decode(SerializationContext context, UaDecoder decoder) {
            UInteger clientHandle = decoder.readUInt32("ClientHandle");
            Double samplingInterval = decoder.readDouble("SamplingInterval");
            ExtensionObject filter = decoder.readExtensionObject("Filter");
            UInteger queueSize = decoder.readUInt32("QueueSize");
            Boolean discardOldest = decoder.readBoolean("DiscardOldest");
            return new MonitoringParameters(clientHandle, samplingInterval, filter, queueSize, discardOldest);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MonitoringParameters value) {
            encoder.writeUInt32("ClientHandle", value.getClientHandle());
            encoder.writeDouble("SamplingInterval", value.getSamplingInterval());
            encoder.writeExtensionObject("Filter", value.getFilter());
            encoder.writeUInt32("QueueSize", value.getQueueSize());
            encoder.writeBoolean("DiscardOldest", value.getDiscardOldest());
        }
    }
}

