/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class EventFieldList
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=917");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=919");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=918");
    private final UInteger clientHandle;
    private final Variant[] eventFields;

    public EventFieldList(UInteger clientHandle, Variant[] eventFields) {
        this.clientHandle = clientHandle;
        this.eventFields = eventFields;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getClientHandle() {
        return this.clientHandle;
    }

    public Variant[] getEventFields() {
        return this.eventFields;
    }

    protected EventFieldList(EventFieldListBuilder<?, ?> b) {
        super(b);
        this.clientHandle = ((EventFieldListBuilder)b).clientHandle;
        this.eventFields = ((EventFieldListBuilder)b).eventFields;
    }

    public static EventFieldListBuilder<?, ?> builder() {
        return new EventFieldListBuilderImpl();
    }

    public EventFieldListBuilder<?, ?> toBuilder() {
        return new EventFieldListBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventFieldList)) {
            return false;
        }
        EventFieldList other = (EventFieldList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$clientHandle = this.getClientHandle();
        UInteger other$clientHandle = other.getClientHandle();
        if (this$clientHandle == null ? other$clientHandle != null : !((Object)this$clientHandle).equals(other$clientHandle)) {
            return false;
        }
        return Arrays.deepEquals(this.getEventFields(), other.getEventFields());
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventFieldList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $clientHandle = this.getClientHandle();
        result = result * 59 + ($clientHandle == null ? 43 : ((Object)$clientHandle).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEventFields());
        return result;
    }

    @Override
    public String toString() {
        return "EventFieldList(clientHandle=" + this.getClientHandle() + ", eventFields=" + Arrays.deepToString(this.getEventFields()) + ")";
    }

    private static final class EventFieldListBuilderImpl
    extends EventFieldListBuilder<EventFieldList, EventFieldListBuilderImpl> {
        private EventFieldListBuilderImpl() {
        }

        @Override
        protected EventFieldListBuilderImpl self() {
            return this;
        }

        @Override
        public EventFieldList build() {
            return new EventFieldList(this);
        }
    }

    public static abstract class EventFieldListBuilder<C extends EventFieldList, B extends EventFieldListBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger clientHandle;
        private Variant[] eventFields;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EventFieldListBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EventFieldList instance, EventFieldListBuilder<?, ?> b) {
            b.clientHandle(instance.clientHandle);
            b.eventFields(instance.eventFields);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B clientHandle(UInteger clientHandle) {
            this.clientHandle = clientHandle;
            return (B)this.self();
        }

        public B eventFields(Variant[] eventFields) {
            this.eventFields = eventFields;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EventFieldList.EventFieldListBuilder(super=" + super.toString() + ", clientHandle=" + this.clientHandle + ", eventFields=" + Arrays.deepToString(this.eventFields) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EventFieldList> {
        @Override
        public Class<EventFieldList> getType() {
            return EventFieldList.class;
        }

        @Override
        public EventFieldList decode(SerializationContext context, UaDecoder decoder) {
            UInteger clientHandle = decoder.readUInt32("ClientHandle");
            Variant[] eventFields = decoder.readVariantArray("EventFields");
            return new EventFieldList(clientHandle, eventFields);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EventFieldList value) {
            encoder.writeUInt32("ClientHandle", value.getClientHandle());
            encoder.writeVariantArray("EventFields", value.getEventFields());
        }
    }
}

