/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDefinition;

public class EnumDescription
extends DataTypeDescription
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15488");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=127");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15590");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15059");
    private final EnumDefinition enumDefinition;
    private final UByte builtInType;

    public EnumDescription(NodeId dataTypeId, QualifiedName name, EnumDefinition enumDefinition, UByte builtInType) {
        super(dataTypeId, name);
        this.enumDefinition = enumDefinition;
        this.builtInType = builtInType;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public EnumDefinition getEnumDefinition() {
        return this.enumDefinition;
    }

    public UByte getBuiltInType() {
        return this.builtInType;
    }

    protected EnumDescription(EnumDescriptionBuilder<?, ?> b) {
        super((DataTypeDescription.DataTypeDescriptionBuilder<?, ?>)b);
        this.enumDefinition = ((EnumDescriptionBuilder)b).enumDefinition;
        this.builtInType = ((EnumDescriptionBuilder)b).builtInType;
    }

    public static EnumDescriptionBuilder<?, ?> builder() {
        return new EnumDescriptionBuilderImpl();
    }

    public EnumDescriptionBuilder<?, ?> toBuilder() {
        return new EnumDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumDescription)) {
            return false;
        }
        EnumDescription other = (EnumDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnumDefinition this$enumDefinition = this.getEnumDefinition();
        EnumDefinition other$enumDefinition = other.getEnumDefinition();
        if (this$enumDefinition == null ? other$enumDefinition != null : !((Object)this$enumDefinition).equals(other$enumDefinition)) {
            return false;
        }
        UByte this$builtInType = this.getBuiltInType();
        UByte other$builtInType = other.getBuiltInType();
        return !(this$builtInType == null ? other$builtInType != null : !((Object)this$builtInType).equals(other$builtInType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnumDescription;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EnumDefinition $enumDefinition = this.getEnumDefinition();
        result = result * 59 + ($enumDefinition == null ? 43 : ((Object)$enumDefinition).hashCode());
        UByte $builtInType = this.getBuiltInType();
        result = result * 59 + ($builtInType == null ? 43 : ((Object)$builtInType).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EnumDescription(enumDefinition=" + this.getEnumDefinition() + ", builtInType=" + this.getBuiltInType() + ")";
    }

    private static final class EnumDescriptionBuilderImpl
    extends EnumDescriptionBuilder<EnumDescription, EnumDescriptionBuilderImpl> {
        private EnumDescriptionBuilderImpl() {
        }

        @Override
        protected EnumDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public EnumDescription build() {
            return new EnumDescription(this);
        }
    }

    public static abstract class EnumDescriptionBuilder<C extends EnumDescription, B extends EnumDescriptionBuilder<C, B>>
    extends DataTypeDescription.DataTypeDescriptionBuilder<C, B> {
        private EnumDefinition enumDefinition;
        private UByte builtInType;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EnumDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EnumDescription instance, EnumDescriptionBuilder<?, ?> b) {
            b.enumDefinition(instance.enumDefinition);
            b.builtInType(instance.builtInType);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B enumDefinition(EnumDefinition enumDefinition) {
            this.enumDefinition = enumDefinition;
            return (B)this.self();
        }

        public B builtInType(UByte builtInType) {
            this.builtInType = builtInType;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EnumDescription.EnumDescriptionBuilder(super=" + super.toString() + ", enumDefinition=" + this.enumDefinition + ", builtInType=" + this.builtInType + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EnumDescription> {
        @Override
        public Class<EnumDescription> getType() {
            return EnumDescription.class;
        }

        @Override
        public EnumDescription decode(SerializationContext context, UaDecoder decoder) {
            NodeId dataTypeId = decoder.readNodeId("DataTypeId");
            QualifiedName name = decoder.readQualifiedName("Name");
            EnumDefinition enumDefinition = (EnumDefinition)decoder.readStruct("EnumDefinition", EnumDefinition.TYPE_ID);
            UByte builtInType = decoder.readByte("BuiltInType");
            return new EnumDescription(dataTypeId, name, enumDefinition, builtInType);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EnumDescription value) {
            encoder.writeNodeId("DataTypeId", value.getDataTypeId());
            encoder.writeQualifiedName("Name", value.getName());
            encoder.writeStruct("EnumDefinition", (Object)value.getEnumDefinition(), EnumDefinition.TYPE_ID);
            encoder.writeByte("BuiltInType", value.getBuiltInType());
        }
    }
}

