/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;

public class EndpointDescription
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=312");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=313");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=314");
    private final String endpointUrl;
    private final ApplicationDescription server;
    private final ByteString serverCertificate;
    private final MessageSecurityMode securityMode;
    private final String securityPolicyUri;
    private final UserTokenPolicy[] userIdentityTokens;
    private final String transportProfileUri;
    private final UByte securityLevel;

    public EndpointDescription(String endpointUrl, ApplicationDescription server, ByteString serverCertificate, MessageSecurityMode securityMode, String securityPolicyUri, UserTokenPolicy[] userIdentityTokens, String transportProfileUri, UByte securityLevel) {
        this.endpointUrl = endpointUrl;
        this.server = server;
        this.serverCertificate = serverCertificate;
        this.securityMode = securityMode;
        this.securityPolicyUri = securityPolicyUri;
        this.userIdentityTokens = userIdentityTokens;
        this.transportProfileUri = transportProfileUri;
        this.securityLevel = securityLevel;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public ApplicationDescription getServer() {
        return this.server;
    }

    public ByteString getServerCertificate() {
        return this.serverCertificate;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public UserTokenPolicy[] getUserIdentityTokens() {
        return this.userIdentityTokens;
    }

    public String getTransportProfileUri() {
        return this.transportProfileUri;
    }

    public UByte getSecurityLevel() {
        return this.securityLevel;
    }

    protected EndpointDescription(EndpointDescriptionBuilder<?, ?> b) {
        super(b);
        this.endpointUrl = ((EndpointDescriptionBuilder)b).endpointUrl;
        this.server = ((EndpointDescriptionBuilder)b).server;
        this.serverCertificate = ((EndpointDescriptionBuilder)b).serverCertificate;
        this.securityMode = ((EndpointDescriptionBuilder)b).securityMode;
        this.securityPolicyUri = ((EndpointDescriptionBuilder)b).securityPolicyUri;
        this.userIdentityTokens = ((EndpointDescriptionBuilder)b).userIdentityTokens;
        this.transportProfileUri = ((EndpointDescriptionBuilder)b).transportProfileUri;
        this.securityLevel = ((EndpointDescriptionBuilder)b).securityLevel;
    }

    public static EndpointDescriptionBuilder<?, ?> builder() {
        return new EndpointDescriptionBuilderImpl();
    }

    public EndpointDescriptionBuilder<?, ?> toBuilder() {
        return new EndpointDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointDescription)) {
            return false;
        }
        EndpointDescription other = (EndpointDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        ApplicationDescription this$server = this.getServer();
        ApplicationDescription other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        ByteString this$serverCertificate = this.getServerCertificate();
        ByteString other$serverCertificate = other.getServerCertificate();
        if (this$serverCertificate == null ? other$serverCertificate != null : !((Object)this$serverCertificate).equals(other$serverCertificate)) {
            return false;
        }
        MessageSecurityMode this$securityMode = this.getSecurityMode();
        MessageSecurityMode other$securityMode = other.getSecurityMode();
        if (this$securityMode == null ? other$securityMode != null : !this$securityMode.equals(other$securityMode)) {
            return false;
        }
        String this$securityPolicyUri = this.getSecurityPolicyUri();
        String other$securityPolicyUri = other.getSecurityPolicyUri();
        if (this$securityPolicyUri == null ? other$securityPolicyUri != null : !this$securityPolicyUri.equals(other$securityPolicyUri)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUserIdentityTokens(), other.getUserIdentityTokens())) {
            return false;
        }
        String this$transportProfileUri = this.getTransportProfileUri();
        String other$transportProfileUri = other.getTransportProfileUri();
        if (this$transportProfileUri == null ? other$transportProfileUri != null : !this$transportProfileUri.equals(other$transportProfileUri)) {
            return false;
        }
        UByte this$securityLevel = this.getSecurityLevel();
        UByte other$securityLevel = other.getSecurityLevel();
        return !(this$securityLevel == null ? other$securityLevel != null : !((Object)this$securityLevel).equals(other$securityLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        ApplicationDescription $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        ByteString $serverCertificate = this.getServerCertificate();
        result = result * 59 + ($serverCertificate == null ? 43 : ((Object)$serverCertificate).hashCode());
        MessageSecurityMode $securityMode = this.getSecurityMode();
        result = result * 59 + ($securityMode == null ? 43 : $securityMode.hashCode());
        String $securityPolicyUri = this.getSecurityPolicyUri();
        result = result * 59 + ($securityPolicyUri == null ? 43 : $securityPolicyUri.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUserIdentityTokens());
        String $transportProfileUri = this.getTransportProfileUri();
        result = result * 59 + ($transportProfileUri == null ? 43 : $transportProfileUri.hashCode());
        UByte $securityLevel = this.getSecurityLevel();
        result = result * 59 + ($securityLevel == null ? 43 : ((Object)$securityLevel).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EndpointDescription(endpointUrl=" + this.getEndpointUrl() + ", server=" + this.getServer() + ", serverCertificate=" + this.getServerCertificate() + ", securityMode=" + this.getSecurityMode() + ", securityPolicyUri=" + this.getSecurityPolicyUri() + ", userIdentityTokens=" + Arrays.deepToString(this.getUserIdentityTokens()) + ", transportProfileUri=" + this.getTransportProfileUri() + ", securityLevel=" + this.getSecurityLevel() + ")";
    }

    private static final class EndpointDescriptionBuilderImpl
    extends EndpointDescriptionBuilder<EndpointDescription, EndpointDescriptionBuilderImpl> {
        private EndpointDescriptionBuilderImpl() {
        }

        @Override
        protected EndpointDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public EndpointDescription build() {
            return new EndpointDescription(this);
        }
    }

    public static abstract class EndpointDescriptionBuilder<C extends EndpointDescription, B extends EndpointDescriptionBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String endpointUrl;
        private ApplicationDescription server;
        private ByteString serverCertificate;
        private MessageSecurityMode securityMode;
        private String securityPolicyUri;
        private UserTokenPolicy[] userIdentityTokens;
        private String transportProfileUri;
        private UByte securityLevel;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EndpointDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EndpointDescription instance, EndpointDescriptionBuilder<?, ?> b) {
            b.endpointUrl(instance.endpointUrl);
            b.server(instance.server);
            b.serverCertificate(instance.serverCertificate);
            b.securityMode(instance.securityMode);
            b.securityPolicyUri(instance.securityPolicyUri);
            b.userIdentityTokens(instance.userIdentityTokens);
            b.transportProfileUri(instance.transportProfileUri);
            b.securityLevel(instance.securityLevel);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return (B)this.self();
        }

        public B server(ApplicationDescription server) {
            this.server = server;
            return (B)this.self();
        }

        public B serverCertificate(ByteString serverCertificate) {
            this.serverCertificate = serverCertificate;
            return (B)this.self();
        }

        public B securityMode(MessageSecurityMode securityMode) {
            this.securityMode = securityMode;
            return (B)this.self();
        }

        public B securityPolicyUri(String securityPolicyUri) {
            this.securityPolicyUri = securityPolicyUri;
            return (B)this.self();
        }

        public B userIdentityTokens(UserTokenPolicy[] userIdentityTokens) {
            this.userIdentityTokens = userIdentityTokens;
            return (B)this.self();
        }

        public B transportProfileUri(String transportProfileUri) {
            this.transportProfileUri = transportProfileUri;
            return (B)this.self();
        }

        public B securityLevel(UByte securityLevel) {
            this.securityLevel = securityLevel;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EndpointDescription.EndpointDescriptionBuilder(super=" + super.toString() + ", endpointUrl=" + this.endpointUrl + ", server=" + this.server + ", serverCertificate=" + this.serverCertificate + ", securityMode=" + this.securityMode + ", securityPolicyUri=" + this.securityPolicyUri + ", userIdentityTokens=" + Arrays.deepToString(this.userIdentityTokens) + ", transportProfileUri=" + this.transportProfileUri + ", securityLevel=" + this.securityLevel + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EndpointDescription> {
        @Override
        public Class<EndpointDescription> getType() {
            return EndpointDescription.class;
        }

        @Override
        public EndpointDescription decode(SerializationContext context, UaDecoder decoder) {
            String endpointUrl = decoder.readString("EndpointUrl");
            ApplicationDescription server = (ApplicationDescription)decoder.readStruct("Server", ApplicationDescription.TYPE_ID);
            ByteString serverCertificate = decoder.readByteString("ServerCertificate");
            MessageSecurityMode securityMode = decoder.readEnum("SecurityMode", MessageSecurityMode.class);
            String securityPolicyUri = decoder.readString("SecurityPolicyUri");
            UserTokenPolicy[] userIdentityTokens = (UserTokenPolicy[])decoder.readStructArray("UserIdentityTokens", UserTokenPolicy.TYPE_ID);
            String transportProfileUri = decoder.readString("TransportProfileUri");
            UByte securityLevel = decoder.readByte("SecurityLevel");
            return new EndpointDescription(endpointUrl, server, serverCertificate, securityMode, securityPolicyUri, userIdentityTokens, transportProfileUri, securityLevel);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EndpointDescription value) {
            encoder.writeString("EndpointUrl", value.getEndpointUrl());
            encoder.writeStruct("Server", (Object)value.getServer(), ApplicationDescription.TYPE_ID);
            encoder.writeByteString("ServerCertificate", value.getServerCertificate());
            encoder.writeEnum("SecurityMode", value.getSecurityMode());
            encoder.writeString("SecurityPolicyUri", value.getSecurityPolicyUri());
            encoder.writeStructArray("UserIdentityTokens", (Object[])value.getUserIdentityTokens(), UserTokenPolicy.TYPE_ID);
            encoder.writeString("TransportProfileUri", value.getTransportProfileUri());
            encoder.writeByte("SecurityLevel", value.getSecurityLevel());
        }
    }
}

