/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.FilterOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;

public class AttributeOperand
extends FilterOperand
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=598");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=599");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=600");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15209");
    private final NodeId nodeId;
    private final String alias;
    private final RelativePath browsePath;
    private final UInteger attributeId;
    private final String indexRange;

    public AttributeOperand(NodeId nodeId, String alias, RelativePath browsePath, UInteger attributeId, String indexRange) {
        this.nodeId = nodeId;
        this.alias = alias;
        this.browsePath = browsePath;
        this.attributeId = attributeId;
        this.indexRange = indexRange;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getAlias() {
        return this.alias;
    }

    public RelativePath getBrowsePath() {
        return this.browsePath;
    }

    public UInteger getAttributeId() {
        return this.attributeId;
    }

    public String getIndexRange() {
        return this.indexRange;
    }

    protected AttributeOperand(AttributeOperandBuilder<?, ?> b) {
        super((FilterOperand.FilterOperandBuilder<?, ?>)b);
        this.nodeId = ((AttributeOperandBuilder)b).nodeId;
        this.alias = ((AttributeOperandBuilder)b).alias;
        this.browsePath = ((AttributeOperandBuilder)b).browsePath;
        this.attributeId = ((AttributeOperandBuilder)b).attributeId;
        this.indexRange = ((AttributeOperandBuilder)b).indexRange;
    }

    public static AttributeOperandBuilder<?, ?> builder() {
        return new AttributeOperandBuilderImpl();
    }

    public AttributeOperandBuilder<?, ?> toBuilder() {
        return new AttributeOperandBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeOperand)) {
            return false;
        }
        AttributeOperand other = (AttributeOperand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeId this$nodeId = this.getNodeId();
        NodeId other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        RelativePath this$browsePath = this.getBrowsePath();
        RelativePath other$browsePath = other.getBrowsePath();
        if (this$browsePath == null ? other$browsePath != null : !((Object)this$browsePath).equals(other$browsePath)) {
            return false;
        }
        UInteger this$attributeId = this.getAttributeId();
        UInteger other$attributeId = other.getAttributeId();
        if (this$attributeId == null ? other$attributeId != null : !((Object)this$attributeId).equals(other$attributeId)) {
            return false;
        }
        String this$indexRange = this.getIndexRange();
        String other$indexRange = other.getIndexRange();
        return !(this$indexRange == null ? other$indexRange != null : !this$indexRange.equals(other$indexRange));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AttributeOperand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        NodeId $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        RelativePath $browsePath = this.getBrowsePath();
        result = result * 59 + ($browsePath == null ? 43 : ((Object)$browsePath).hashCode());
        UInteger $attributeId = this.getAttributeId();
        result = result * 59 + ($attributeId == null ? 43 : ((Object)$attributeId).hashCode());
        String $indexRange = this.getIndexRange();
        result = result * 59 + ($indexRange == null ? 43 : $indexRange.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AttributeOperand(nodeId=" + this.getNodeId() + ", alias=" + this.getAlias() + ", browsePath=" + this.getBrowsePath() + ", attributeId=" + this.getAttributeId() + ", indexRange=" + this.getIndexRange() + ")";
    }

    private static final class AttributeOperandBuilderImpl
    extends AttributeOperandBuilder<AttributeOperand, AttributeOperandBuilderImpl> {
        private AttributeOperandBuilderImpl() {
        }

        @Override
        protected AttributeOperandBuilderImpl self() {
            return this;
        }

        @Override
        public AttributeOperand build() {
            return new AttributeOperand(this);
        }
    }

    public static abstract class AttributeOperandBuilder<C extends AttributeOperand, B extends AttributeOperandBuilder<C, B>>
    extends FilterOperand.FilterOperandBuilder<C, B> {
        private NodeId nodeId;
        private String alias;
        private RelativePath browsePath;
        private UInteger attributeId;
        private String indexRange;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AttributeOperandBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AttributeOperand instance, AttributeOperandBuilder<?, ?> b) {
            b.nodeId(instance.nodeId);
            b.alias(instance.alias);
            b.browsePath(instance.browsePath);
            b.attributeId(instance.attributeId);
            b.indexRange(instance.indexRange);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B nodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return (B)this.self();
        }

        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        public B browsePath(RelativePath browsePath) {
            this.browsePath = browsePath;
            return (B)this.self();
        }

        public B attributeId(UInteger attributeId) {
            this.attributeId = attributeId;
            return (B)this.self();
        }

        public B indexRange(String indexRange) {
            this.indexRange = indexRange;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AttributeOperand.AttributeOperandBuilder(super=" + super.toString() + ", nodeId=" + this.nodeId + ", alias=" + this.alias + ", browsePath=" + this.browsePath + ", attributeId=" + this.attributeId + ", indexRange=" + this.indexRange + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AttributeOperand> {
        @Override
        public Class<AttributeOperand> getType() {
            return AttributeOperand.class;
        }

        @Override
        public AttributeOperand decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            String alias = decoder.readString("Alias");
            RelativePath browsePath = (RelativePath)decoder.readStruct("BrowsePath", RelativePath.TYPE_ID);
            UInteger attributeId = decoder.readUInt32("AttributeId");
            String indexRange = decoder.readString("IndexRange");
            return new AttributeOperand(nodeId, alias, browsePath, attributeId, indexRange);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AttributeOperand value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeString("Alias", value.getAlias());
            encoder.writeStruct("BrowsePath", (Object)value.getBrowsePath(), RelativePath.TYPE_ID);
            encoder.writeUInt32("AttributeId", value.getAttributeId());
            encoder.writeString("IndexRange", value.getIndexRange());
        }
    }
}

