/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ActivateSessionRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=465");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=467");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=466");
    private final RequestHeader requestHeader;
    private final SignatureData clientSignature;
    private final SignedSoftwareCertificate[] clientSoftwareCertificates;
    private final String[] localeIds;
    private final ExtensionObject userIdentityToken;
    private final SignatureData userTokenSignature;

    public ActivateSessionRequest(RequestHeader requestHeader, SignatureData clientSignature, SignedSoftwareCertificate[] clientSoftwareCertificates, String[] localeIds, ExtensionObject userIdentityToken, SignatureData userTokenSignature) {
        this.requestHeader = requestHeader;
        this.clientSignature = clientSignature;
        this.clientSoftwareCertificates = clientSoftwareCertificates;
        this.localeIds = localeIds;
        this.userIdentityToken = userIdentityToken;
        this.userTokenSignature = userTokenSignature;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public SignatureData getClientSignature() {
        return this.clientSignature;
    }

    public SignedSoftwareCertificate[] getClientSoftwareCertificates() {
        return this.clientSoftwareCertificates;
    }

    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public ExtensionObject getUserIdentityToken() {
        return this.userIdentityToken;
    }

    public SignatureData getUserTokenSignature() {
        return this.userTokenSignature;
    }

    protected ActivateSessionRequest(ActivateSessionRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((ActivateSessionRequestBuilder)b).requestHeader;
        this.clientSignature = ((ActivateSessionRequestBuilder)b).clientSignature;
        this.clientSoftwareCertificates = ((ActivateSessionRequestBuilder)b).clientSoftwareCertificates;
        this.localeIds = ((ActivateSessionRequestBuilder)b).localeIds;
        this.userIdentityToken = ((ActivateSessionRequestBuilder)b).userIdentityToken;
        this.userTokenSignature = ((ActivateSessionRequestBuilder)b).userTokenSignature;
    }

    public static ActivateSessionRequestBuilder<?, ?> builder() {
        return new ActivateSessionRequestBuilderImpl();
    }

    public ActivateSessionRequestBuilder<?, ?> toBuilder() {
        return new ActivateSessionRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivateSessionRequest)) {
            return false;
        }
        ActivateSessionRequest other = (ActivateSessionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        SignatureData this$clientSignature = this.getClientSignature();
        SignatureData other$clientSignature = other.getClientSignature();
        if (this$clientSignature == null ? other$clientSignature != null : !((Object)this$clientSignature).equals(other$clientSignature)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getClientSoftwareCertificates(), other.getClientSoftwareCertificates())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLocaleIds(), other.getLocaleIds())) {
            return false;
        }
        ExtensionObject this$userIdentityToken = this.getUserIdentityToken();
        ExtensionObject other$userIdentityToken = other.getUserIdentityToken();
        if (this$userIdentityToken == null ? other$userIdentityToken != null : !((Object)this$userIdentityToken).equals(other$userIdentityToken)) {
            return false;
        }
        SignatureData this$userTokenSignature = this.getUserTokenSignature();
        SignatureData other$userTokenSignature = other.getUserTokenSignature();
        return !(this$userTokenSignature == null ? other$userTokenSignature != null : !((Object)this$userTokenSignature).equals(other$userTokenSignature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivateSessionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        SignatureData $clientSignature = this.getClientSignature();
        result = result * 59 + ($clientSignature == null ? 43 : ((Object)$clientSignature).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getClientSoftwareCertificates());
        result = result * 59 + Arrays.deepHashCode(this.getLocaleIds());
        ExtensionObject $userIdentityToken = this.getUserIdentityToken();
        result = result * 59 + ($userIdentityToken == null ? 43 : ((Object)$userIdentityToken).hashCode());
        SignatureData $userTokenSignature = this.getUserTokenSignature();
        result = result * 59 + ($userTokenSignature == null ? 43 : ((Object)$userTokenSignature).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ActivateSessionRequest(requestHeader=" + this.getRequestHeader() + ", clientSignature=" + this.getClientSignature() + ", clientSoftwareCertificates=" + Arrays.deepToString(this.getClientSoftwareCertificates()) + ", localeIds=" + Arrays.deepToString(this.getLocaleIds()) + ", userIdentityToken=" + this.getUserIdentityToken() + ", userTokenSignature=" + this.getUserTokenSignature() + ")";
    }

    private static final class ActivateSessionRequestBuilderImpl
    extends ActivateSessionRequestBuilder<ActivateSessionRequest, ActivateSessionRequestBuilderImpl> {
        private ActivateSessionRequestBuilderImpl() {
        }

        @Override
        protected ActivateSessionRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ActivateSessionRequest build() {
            return new ActivateSessionRequest(this);
        }
    }

    public static abstract class ActivateSessionRequestBuilder<C extends ActivateSessionRequest, B extends ActivateSessionRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private SignatureData clientSignature;
        private SignedSoftwareCertificate[] clientSoftwareCertificates;
        private String[] localeIds;
        private ExtensionObject userIdentityToken;
        private SignatureData userTokenSignature;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ActivateSessionRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ActivateSessionRequest instance, ActivateSessionRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.clientSignature(instance.clientSignature);
            b.clientSoftwareCertificates(instance.clientSoftwareCertificates);
            b.localeIds(instance.localeIds);
            b.userIdentityToken(instance.userIdentityToken);
            b.userTokenSignature(instance.userTokenSignature);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B clientSignature(SignatureData clientSignature) {
            this.clientSignature = clientSignature;
            return (B)this.self();
        }

        public B clientSoftwareCertificates(SignedSoftwareCertificate[] clientSoftwareCertificates) {
            this.clientSoftwareCertificates = clientSoftwareCertificates;
            return (B)this.self();
        }

        public B localeIds(String[] localeIds) {
            this.localeIds = localeIds;
            return (B)this.self();
        }

        public B userIdentityToken(ExtensionObject userIdentityToken) {
            this.userIdentityToken = userIdentityToken;
            return (B)this.self();
        }

        public B userTokenSignature(SignatureData userTokenSignature) {
            this.userTokenSignature = userTokenSignature;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ActivateSessionRequest.ActivateSessionRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", clientSignature=" + this.clientSignature + ", clientSoftwareCertificates=" + Arrays.deepToString(this.clientSoftwareCertificates) + ", localeIds=" + Arrays.deepToString(this.localeIds) + ", userIdentityToken=" + this.userIdentityToken + ", userTokenSignature=" + this.userTokenSignature + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ActivateSessionRequest> {
        @Override
        public Class<ActivateSessionRequest> getType() {
            return ActivateSessionRequest.class;
        }

        @Override
        public ActivateSessionRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            SignatureData clientSignature = (SignatureData)decoder.readStruct("ClientSignature", SignatureData.TYPE_ID);
            SignedSoftwareCertificate[] clientSoftwareCertificates = (SignedSoftwareCertificate[])decoder.readStructArray("ClientSoftwareCertificates", SignedSoftwareCertificate.TYPE_ID);
            String[] localeIds = decoder.readStringArray("LocaleIds");
            ExtensionObject userIdentityToken = decoder.readExtensionObject("UserIdentityToken");
            SignatureData userTokenSignature = (SignatureData)decoder.readStruct("UserTokenSignature", SignatureData.TYPE_ID);
            return new ActivateSessionRequest(requestHeader, clientSignature, clientSoftwareCertificates, localeIds, userIdentityToken, userTokenSignature);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ActivateSessionRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStruct("ClientSignature", (Object)value.getClientSignature(), SignatureData.TYPE_ID);
            encoder.writeStructArray("ClientSoftwareCertificates", (Object[])value.getClientSoftwareCertificates(), SignedSoftwareCertificate.TYPE_ID);
            encoder.writeStringArray("LocaleIds", value.getLocaleIds());
            encoder.writeExtensionObject("UserIdentityToken", value.getUserIdentityToken());
            encoder.writeStruct("UserTokenSignature", (Object)value.getUserTokenSignature(), SignatureData.TYPE_ID);
        }
    }
}

