/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum NamingRuleType implements UaEnumeration
{
    Mandatory(1),
    Optional(2),
    Constraint(3);

    private final int value;

    private NamingRuleType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static NamingRuleType from(int value) {
        switch (value) {
            case 1: {
                return Mandatory;
            }
            case 2: {
                return Optional;
            }
            case 3: {
                return Constraint;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=120");
    }

    public static class Codec
    extends GenericDataTypeCodec<NamingRuleType> {
        @Override
        public Class<NamingRuleType> getType() {
            return NamingRuleType.class;
        }

        @Override
        public NamingRuleType decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, NamingRuleType.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, NamingRuleType value) {
            encoder.writeEnum(null, value);
        }
    }
}

