/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExpandedNodeIdConversions {
    private ExpandedNodeIdConversions() {
    }

    @Nullable
    static NodeId expandedNodeIdToNodeId(@NotNull ExpandedNodeId e) {
        return e.toNodeId(new NamespaceTable()).orElse(null);
    }

    @NotNull
    static String expandedNodeIdToString(@NotNull ExpandedNodeId e) {
        return e.toParseableString();
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof ExpandedNodeId) {
            ExpandedNodeId eni = (ExpandedNodeId)o;
            return implicit ? ExpandedNodeIdConversions.implicitConversion(eni, targetType) : ExpandedNodeIdConversions.explicitConversion(eni, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull ExpandedNodeId eni, BuiltinDataType targetType) {
        switch (targetType) {
            case NodeId: {
                return ExpandedNodeIdConversions.expandedNodeIdToNodeId(eni);
            }
        }
        return ExpandedNodeIdConversions.implicitConversion(eni, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull ExpandedNodeId eni, BuiltinDataType targetType) {
        switch (targetType) {
            case String: {
                return ExpandedNodeIdConversions.expandedNodeIdToString(eni);
            }
        }
        return null;
    }
}

