/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.function.Supplier;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;

public interface RetryPolicies {
    public static RetryPolicy retryForeverNoSleep() {
        return Constants.RETRY_FOREVER_NO_SLEEP;
    }

    public static RetryPolicy noRetry() {
        return Constants.NO_RETRY;
    }

    public static RetryForeverWithSleep retryForeverWithSleep(TimeDuration sleepTime) {
        return new RetryForeverWithSleep(sleepTime);
    }

    public static RetryLimited retryUpToMaximumCountWithFixedSleep(int maxAttempts, TimeDuration sleepTime) {
        return new RetryLimited(maxAttempts, sleepTime);
    }

    public static final class RetryLimited
    extends RetryForeverWithSleep {
        private final int maxAttempts;
        private final Supplier<String> myString;

        private RetryLimited(int maxAttempts, TimeDuration sleepTime) {
            super(sleepTime);
            if (maxAttempts < 0) {
                throw new IllegalArgumentException("maxAttempts = " + maxAttempts + " < 0");
            }
            this.maxAttempts = maxAttempts;
            this.myString = JavaUtils.memoize(() -> JavaUtils.getClassSimpleName(this.getClass()) + "(maxAttempts=" + maxAttempts + ", sleepTime=" + sleepTime + ")");
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        @Override
        public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
            return event.getAttemptCount() < this.maxAttempts ? super.handleAttemptFailure(event) : NO_RETRY_ACTION;
        }

        @Override
        public String toString() {
            return this.myString.get();
        }
    }

    public static class RetryForeverWithSleep
    implements RetryPolicy {
        private final TimeDuration sleepTime;

        private RetryForeverWithSleep(TimeDuration sleepTime) {
            Preconditions.assertTrue(!sleepTime.isNegative(), () -> "sleepTime = " + sleepTime + " < 0");
            this.sleepTime = sleepTime;
        }

        @Override
        public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
            return () -> this.sleepTime;
        }

        public String toString() {
            return JavaUtils.getClassSimpleName(this.getClass()) + "(sleepTime = " + this.sleepTime + ")";
        }
    }

    public static final class NoRetry
    implements RetryPolicy {
        private NoRetry() {
        }

        @Override
        public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
            return RetryPolicy.NO_RETRY_ACTION;
        }

        public String toString() {
            return JavaUtils.getClassSimpleName(this.getClass());
        }
    }

    public static final class RetryForeverNoSleep
    implements RetryPolicy {
        private RetryForeverNoSleep() {
        }

        @Override
        public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
            return RetryPolicy.RETRY_WITHOUT_SLEEP_ACTION;
        }

        public String toString() {
            return JavaUtils.getClassSimpleName(this.getClass());
        }
    }

    public static class Constants {
        private static final RetryForeverNoSleep RETRY_FOREVER_NO_SLEEP = new RetryForeverNoSleep();
        private static final NoRetry NO_RETRY = new NoRetry();
    }
}

