/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RaftRpcMessage;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

public abstract class RaftClientMessage
implements RaftRpcMessage {
    private final ClientId clientId;
    private final RaftPeerId serverId;
    private final RaftGroupId groupId;
    private final long callId;

    RaftClientMessage(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId) {
        this.clientId = Preconditions.assertNotNull(clientId, "clientId");
        this.serverId = Preconditions.assertNotNull(serverId, "serverId");
        this.groupId = Preconditions.assertNotNull(groupId, "groupId");
        this.callId = callId;
    }

    @Override
    public String getRequestorId() {
        return this.clientId.toString();
    }

    @Override
    public String getReplierId() {
        return this.serverId.toString();
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public RaftPeerId getServerId() {
        return this.serverId;
    }

    @Override
    public RaftGroupId getRaftGroupId() {
        return this.groupId;
    }

    public long getCallId() {
        return this.callId;
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.clientId + "->" + this.serverId + (this.groupId != null ? "@" + this.groupId : "") + ", cid=" + this.getCallId();
    }
}

