/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.response;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;

public class PipeSubscribePollResp
extends TPipeSubscribeResp {
    private final transient List<SubscriptionPollResponse> responses = new ArrayList<SubscriptionPollResponse>();

    public List<SubscriptionPollResponse> getResponses() {
        return this.responses;
    }

    public static PipeSubscribePollResp toTPipeSubscribeResp(TSStatus status, List<ByteBuffer> byteBuffers) {
        PipeSubscribePollResp resp = new PipeSubscribePollResp();
        resp.status = status;
        resp.version = PipeSubscribeResponseVersion.VERSION_1.getVersion();
        resp.type = PipeSubscribeResponseType.ACK.getType();
        resp.body = byteBuffers;
        return resp;
    }

    public static PipeSubscribePollResp fromTPipeSubscribeResp(TPipeSubscribeResp pollResp) {
        PipeSubscribePollResp resp = new PipeSubscribePollResp();
        if (Objects.nonNull(pollResp.body)) {
            for (ByteBuffer byteBuffer : pollResp.body) {
                if (!Objects.nonNull(byteBuffer) || !byteBuffer.hasRemaining()) continue;
                resp.responses.add(SubscriptionPollResponse.deserialize(byteBuffer));
            }
        }
        resp.status = pollResp.status;
        resp.version = pollResp.version;
        resp.type = pollResp.type;
        resp.body = pollResp.body;
        return resp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribePollResp that = (PipeSubscribePollResp)((Object)obj);
        return Objects.equals(this.responses, that.responses) && Objects.equals(this.status, that.status) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.responses, this.status, this.version, this.type, this.body);
    }
}

