/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import org.apache.iotdb.rpc.AutoResizingBuffer;
import org.apache.iotdb.rpc.NonOpenTransport;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TTransportException;

public class AutoScalingBufferWriteTransport
extends NonOpenTransport {
    private final AutoResizingBuffer buf;
    private int pos;

    public AutoScalingBufferWriteTransport(int initialCapacity) {
        this.buf = new AutoResizingBuffer(initialCapacity);
        this.pos = 0;
    }

    public int read(byte[] buf, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] toWrite, int off, int len) {
        this.buf.resizeIfNecessary(this.pos + len);
        System.arraycopy(toWrite, off, this.buf.array(), this.pos, len);
        this.pos += len;
    }

    public int getPos() {
        return this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    public void resizeIfNecessary(int size) {
        this.buf.resizeIfNecessary(size);
    }

    public byte[] getBuffer() {
        return this.buf.array();
    }

    public TConfiguration getConfiguration() {
        return null;
    }

    public void updateKnownMessageSize(long size) throws TTransportException {
    }

    public void checkReadBytesAvailable(long numBytes) throws TTransportException {
    }
}

