/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.resource.log;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionLogStatus {
    private static final long BASE_INTERVAL_IN_MS = SubscriptionConfig.getInstance().getSubscriptionLogManagerBaseIntervalMs();
    private final Logger logger;
    private final Cache<Pair<String, String>, AtomicLong> lastReportTimestamps;

    public SubscriptionLogStatus(Class<?> logClass) {
        this.logger = LoggerFactory.getLogger(logClass);
        this.lastReportTimestamps = Caffeine.newBuilder().expireAfterAccess(SubscriptionConfig.getInstance().getSubscriptionLogManagerWindowSeconds(), TimeUnit.SECONDS).build();
    }

    public Optional<Logger> schedule(String consumerGroupId, String topicName) {
        Pair key = new Pair((Object)consumerGroupId, (Object)topicName);
        long now = System.currentTimeMillis();
        int count = SubscriptionAgent.broker().getPrefetchingQueueCount();
        long allowedInterval = BASE_INTERVAL_IN_MS * (long)count;
        AtomicLong lastTime = Objects.requireNonNull((AtomicLong)this.lastReportTimestamps.get((Object)key, k -> new AtomicLong(now - BASE_INTERVAL_IN_MS * ThreadLocalRandom.current().nextLong(1L, count + 1))));
        long last = lastTime.get();
        if (now - last >= allowedInterval && lastTime.compareAndSet(last, now)) {
            return Optional.of(this.logger);
        }
        return Optional.empty();
    }
}

