/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MovingAverages;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTabletQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatch;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTabletIterationSnapshot;
import org.apache.iotdb.metrics.core.utils.IoTDBMovingAverage;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPipeTabletEventBatch
extends SubscriptionPipeEventBatch
implements Iterator<List<Tablet>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPipeTabletEventBatch.class);
    private long firstEventProcessingTime = Long.MIN_VALUE;
    private long totalBufferSize = 0L;
    private volatile Iterator<EnrichedEvent> currentEnrichedEventsIterator;
    private volatile Iterator<TabletInsertionEvent> currentTabletInsertionEventsIterator;
    private volatile TsFileInsertionEvent currentTsFileInsertionEvent;
    private final Meter insertNodeTabletInsertionEventSizeEstimator;
    private final Meter rawTabletInsertionEventSizeEstimator;
    private volatile SubscriptionPipeTabletIterationSnapshot iterationSnapshot;
    private final AtomicInteger referenceCount = new AtomicInteger();
    private static final long ITERATED_COUNT_REPORT_FREQ = 30000L;
    private final AtomicLong iteratedCount = new AtomicLong();

    public SubscriptionPipeTabletEventBatch(int regionId, SubscriptionPrefetchingTabletQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        super(regionId, prefetchingQueue, maxDelayInMs, maxBatchSizeInBytes);
        this.insertNodeTabletInsertionEventSizeEstimator = new Meter((MovingAverages)new IoTDBMovingAverage(), Clock.defaultClock());
        this.rawTabletInsertionEventSizeEstimator = new Meter((MovingAverages)new IoTDBMovingAverage(), Clock.defaultClock());
        this.resetForIteration();
    }

    @Override
    public synchronized void ack() {
        this.referenceCount.decrementAndGet();
        if (!this.hasNext() && this.referenceCount.get() == 0) {
            for (EnrichedEvent enrichedEvent : this.enrichedEvents) {
                enrichedEvent.decreaseReferenceCount(this.getClass().getName(), true);
            }
        }
    }

    @Override
    public synchronized void cleanUp(boolean force) {
        if (!force && (this.hasNext() || this.referenceCount.get() != 0)) {
            return;
        }
        for (EnrichedEvent enrichedEvent : this.enrichedEvents) {
            enrichedEvent.clearReferenceCount(this.getClass().getName());
        }
        this.enrichedEvents.clear();
        this.resetForIteration();
    }

    @Override
    protected void onTabletInsertionEvent(TabletInsertionEvent event) {
        if (this.firstEventProcessingTime == Long.MIN_VALUE) {
            this.firstEventProcessingTime = System.currentTimeMillis();
        }
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            this.totalBufferSize += this.getEstimatedInsertNodeTabletInsertionEventSize();
        } else if (event instanceof PipeRawTabletInsertionEvent) {
            this.totalBufferSize += this.getEstimatedRawTabletInsertionEventSize();
        }
    }

    @Override
    protected void onTsFileInsertionEvent(TsFileInsertionEvent event) {
        if (this.firstEventProcessingTime == Long.MIN_VALUE) {
            this.firstEventProcessingTime = System.currentTimeMillis();
        }
        this.totalBufferSize += ((PipeTsFileInsertionEvent)event).getTsFile().length();
    }

    @Override
    protected List<SubscriptionEvent> generateSubscriptionEvents() {
        this.resetForIteration();
        return Collections.singletonList(new SubscriptionEvent(this, this.prefetchingQueue));
    }

    @Override
    protected boolean shouldEmit() {
        return this.totalBufferSize >= this.maxBatchSizeInBytes || System.currentTimeMillis() - this.firstEventProcessingTime >= (long)this.maxDelayInMs || (long)this.enrichedEvents.size() >= SubscriptionConfig.getInstance().getSubscriptionMaxAllowedEventCountInTabletBatch();
    }

    private List<Tablet> convertToTablets(TabletInsertionEvent tabletInsertionEvent) {
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            List<Tablet> tablets = ((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent).convertToTablets();
            this.updateEstimatedInsertNodeTabletInsertionEventSize(tablets.stream().map(PipeMemoryWeightUtil::calculateTabletSizeInBytes).reduce(Long::sum).orElse(0L));
            return tablets;
        }
        if (tabletInsertionEvent instanceof PipeRawTabletInsertionEvent) {
            Tablet tablet = ((PipeRawTabletInsertionEvent)tabletInsertionEvent).convertToTablet();
            this.updateEstimatedRawTabletInsertionEventSize(PipeMemoryWeightUtil.calculateTabletSizeInBytes(tablet));
            return Collections.singletonList(tablet);
        }
        LOGGER.warn("SubscriptionPipeTabletEventBatch {} only support convert PipeInsertNodeTabletInsertionEvent or PipeRawTabletInsertionEvent to tablet. Ignore {}.", (Object)this, (Object)tabletInsertionEvent);
        return Collections.emptyList();
    }

    private long getEstimatedInsertNodeTabletInsertionEventSize() {
        return Math.max(SubscriptionConfig.getInstance().getSubscriptionEstimatedInsertNodeTabletInsertionEventSize(), (long)this.insertNodeTabletInsertionEventSizeEstimator.getOneMinuteRate());
    }

    private void updateEstimatedInsertNodeTabletInsertionEventSize(long size) {
        this.insertNodeTabletInsertionEventSizeEstimator.mark(size);
    }

    private long getEstimatedRawTabletInsertionEventSize() {
        return Math.max(SubscriptionConfig.getInstance().getSubscriptionEstimatedRawTabletInsertionEventSize(), (long)this.rawTabletInsertionEventSizeEstimator.getOneMinuteRate());
    }

    private void updateEstimatedRawTabletInsertionEventSize(long size) {
        this.rawTabletInsertionEventSizeEstimator.mark(size);
    }

    public synchronized SubscriptionPipeTabletIterationSnapshot sendIterationSnapshot() {
        SubscriptionPipeTabletIterationSnapshot result = this.iterationSnapshot;
        this.iterationSnapshot = new SubscriptionPipeTabletIterationSnapshot();
        this.referenceCount.incrementAndGet();
        return result;
    }

    public synchronized void resetForIteration() {
        this.currentEnrichedEventsIterator = this.enrichedEvents.iterator();
        this.currentTabletInsertionEventsIterator = null;
        if (Objects.nonNull(this.currentTsFileInsertionEvent) && this.currentTsFileInsertionEvent instanceof PipeTsFileInsertionEvent) {
            ((PipeTsFileInsertionEvent)this.currentTsFileInsertionEvent).close();
        }
        this.currentTsFileInsertionEvent = null;
        if (Objects.nonNull(this.iterationSnapshot)) {
            this.iterationSnapshot.cleanUp();
        }
        this.iterationSnapshot = new SubscriptionPipeTabletIterationSnapshot();
        this.referenceCount.set(0);
        this.iteratedCount.set(0L);
    }

    @Override
    public synchronized boolean hasNext() {
        if (Objects.nonNull(this.currentTabletInsertionEventsIterator)) {
            if (this.currentTabletInsertionEventsIterator.hasNext()) {
                return true;
            }
            this.currentTabletInsertionEventsIterator = null;
            this.currentTsFileInsertionEvent = null;
            return this.hasNext();
        }
        if (Objects.isNull(this.currentEnrichedEventsIterator)) {
            return false;
        }
        if (this.currentEnrichedEventsIterator.hasNext()) {
            return true;
        }
        this.currentEnrichedEventsIterator = null;
        return false;
    }

    @Override
    public synchronized List<Tablet> next() {
        List<Tablet> tablets = this.nextInternal();
        if (Objects.isNull(tablets)) {
            return null;
        }
        if (this.iteratedCount.incrementAndGet() % 30000L == 0L) {
            LOGGER.info("{} has been iterated {} times, current TsFileInsertionEvent {}", new Object[]{this, this.iteratedCount, Objects.isNull(this.currentTsFileInsertionEvent) ? "<unknown>" : ((EnrichedEvent)this.currentTsFileInsertionEvent).coreReportMessage()});
        }
        return tablets;
    }

    private List<Tablet> nextInternal() {
        if (Objects.nonNull(this.currentTabletInsertionEventsIterator)) {
            if (this.currentTabletInsertionEventsIterator.hasNext()) {
                TabletInsertionEvent tabletInsertionEvent = this.currentTabletInsertionEventsIterator.next();
                if (!(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
                    LOGGER.warn("SubscriptionPipeTabletEventBatch: Unexpected tablet insertion event {}, skipping it.", (Object)tabletInsertionEvent);
                } else if (!((PipeRawTabletInsertionEvent)tabletInsertionEvent).increaseReferenceCount(this.getClass().getName())) {
                    LOGGER.warn("SubscriptionPipeTabletEventBatch: Failed to increase the reference count of event {}, skipping it.", (Object)((PipeRawTabletInsertionEvent)tabletInsertionEvent).coreReportMessage());
                } else {
                    this.iterationSnapshot.addParsedEnrichedEvent((PipeRawTabletInsertionEvent)tabletInsertionEvent);
                }
                if (!this.currentTabletInsertionEventsIterator.hasNext()) {
                    this.iterationSnapshot.addIteratedEnrichedEvent((EnrichedEvent)this.currentTsFileInsertionEvent);
                }
                return this.convertToTablets(tabletInsertionEvent);
            }
            this.currentTabletInsertionEventsIterator = null;
            this.currentTsFileInsertionEvent = null;
        }
        if (Objects.isNull(this.currentEnrichedEventsIterator)) {
            return null;
        }
        if (!this.currentEnrichedEventsIterator.hasNext()) {
            return null;
        }
        EnrichedEvent enrichedEvent = this.currentEnrichedEventsIterator.next();
        if (enrichedEvent instanceof TsFileInsertionEvent) {
            if (Objects.nonNull(this.currentTabletInsertionEventsIterator)) {
                LOGGER.warn("SubscriptionPipeTabletEventBatch {} override non-null currentTabletInsertionEventsIterator when iterating (broken invariant).", (Object)this);
            }
            PipeTsFileInsertionEvent tsFileInsertionEvent = (PipeTsFileInsertionEvent)enrichedEvent;
            this.currentTsFileInsertionEvent = tsFileInsertionEvent;
            this.currentTabletInsertionEventsIterator = tsFileInsertionEvent.toTabletInsertionEvents((long)((1.0 + Math.random()) * (double)SubscriptionAgent.receiver().remainingMs())).iterator();
            return this.next();
        }
        if (enrichedEvent instanceof TabletInsertionEvent) {
            this.iterationSnapshot.addIteratedEnrichedEvent(enrichedEvent);
            return this.convertToTablets((TabletInsertionEvent)enrichedEvent);
        }
        LOGGER.warn("SubscriptionPipeTabletEventBatch {} ignore EnrichedEvent {} when iterating (broken invariant).", (Object)this, (Object)enrichedEvent);
        return null;
    }
}

