/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event.batch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTabletQueue;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingTsFileQueue;
import org.apache.iotdb.db.subscription.event.SubscriptionEvent;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeEventBatch;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTabletEventBatch;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTsFileEventBatch;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPipeEventBatches {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPipeEventBatches.class);
    protected final SubscriptionPrefetchingQueue prefetchingQueue;
    protected final int maxDelayInMs;
    protected final long maxBatchSizeInBytes;
    private final Map<Integer, SubscriptionPipeEventBatch> regionIdToBatch;

    public SubscriptionPipeEventBatches(SubscriptionPrefetchingQueue prefetchingQueue, int maxDelayInMs, long maxBatchSizeInBytes) {
        this.prefetchingQueue = prefetchingQueue;
        this.maxDelayInMs = maxDelayInMs;
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
        this.regionIdToBatch = new ConcurrentHashMap<Integer, SubscriptionPipeEventBatch>();
    }

    public boolean onEvent(Consumer<SubscriptionEvent> consumer) {
        AtomicBoolean hasNew = new AtomicBoolean(false);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.copyOf(this.regionIdToBatch.keySet()).iterator();
        while (unmodifiableIterator.hasNext()) {
            int regionId = (Integer)unmodifiableIterator.next();
            this.regionIdToBatch.compute(regionId, (key, batch) -> {
                if (Objects.isNull(batch)) {
                    return null;
                }
                try {
                    if (batch.onEvent(consumer)) {
                        hasNew.set(true);
                        return null;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Exception occurred when sealing events from batch {}", batch, (Object)e);
                }
                return batch;
            });
            if (!hasNew.get()) continue;
            break;
        }
        return hasNew.get();
    }

    public boolean onEvent(@NonNull EnrichedEvent event, Consumer<SubscriptionEvent> consumer) {
        int regionId = event.getCommitterKey().getRegionId();
        AtomicBoolean hasNew = new AtomicBoolean(false);
        this.regionIdToBatch.compute(regionId, (key, batch) -> {
            if (Objects.isNull(batch)) {
                batch = this.prefetchingQueue instanceof SubscriptionPrefetchingTabletQueue ? new SubscriptionPipeTabletEventBatch((int)key, (SubscriptionPrefetchingTabletQueue)this.prefetchingQueue, this.maxDelayInMs, this.maxBatchSizeInBytes) : new SubscriptionPipeTsFileEventBatch((int)key, (SubscriptionPrefetchingTsFileQueue)this.prefetchingQueue, this.maxDelayInMs, this.maxBatchSizeInBytes);
            }
            try {
                if (batch.onEvent(event, consumer)) {
                    hasNew.set(true);
                    return null;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception occurred when sealing events from batch {}", batch, (Object)e);
            }
            return batch;
        });
        return hasNew.get();
    }

    public void cleanUp() {
        this.regionIdToBatch.values().forEach(batch -> batch.cleanUp(true));
        this.regionIdToBatch.clear();
    }
}

