/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.converter;

import org.apache.iotdb.db.pipe.receiver.transform.converter.ArrayConverter;
import org.apache.iotdb.db.pipe.receiver.transform.statement.PipeConvertedInsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadConvertedInsertTabletStatement
extends PipeConvertedInsertTabletStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadConvertedInsertTabletStatement.class);
    private final boolean shouldConvertOnTypeMismatch;

    public LoadConvertedInsertTabletStatement(InsertTabletStatement insertTabletStatement, boolean shouldConvertOnTypeMismatch) {
        super(insertTabletStatement);
        this.shouldConvertOnTypeMismatch = shouldConvertOnTypeMismatch;
    }

    @Override
    protected boolean checkAndCastDataType(int columnIndex, TSDataType dataType) {
        if (!this.shouldConvertOnTypeMismatch) {
            return this.originalCheckAndCastDataType(columnIndex, dataType);
        }
        LOGGER.info("Load: Inserting tablet to {}.{}. Casting type from {} to {}.", new Object[]{this.devicePath, this.measurements[columnIndex], this.dataTypes[columnIndex], dataType});
        this.columns[columnIndex] = ArrayConverter.convert(this.dataTypes[columnIndex], dataType, this.columns[columnIndex]);
        this.dataTypes[columnIndex] = dataType;
        return true;
    }
}

